/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative;

import com.dynatrace.buildtools.graalnative.AgentDownload;
import com.dynatrace.buildtools.graalnative.ConfigurationException;
import com.dynatrace.buildtools.graalnative.DynatraceLogger;
import com.dynatrace.buildtools.graalnative.DynatraceProperties;
import com.dynatrace.buildtools.graalnative.shared.DownloadException;
import com.dynatrace.buildtools.graalnative.shared.DynatraceAgentDirectoryUtils;
import com.dynatrace.buildtools.graalnative.shared.DynatraceRestApi;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.project.MavenProject;

public final class DynatraceAgentDirectory {
    public static File setup(String agentDir, String agentZip, AgentDownload agentDownload, MavenProject project, MavenProject topLevelProject, DynatraceLogger logger) throws ConfigurationException, IOException, DownloadException {
        File preparedAgentDir;
        Object[] objectArray = new Object[3];
        objectArray[0] = agentDir;
        objectArray[1] = agentZip;
        Object object = objectArray[2] = agentDownload.isPresent() ? agentDownload : null;
        if (DynatraceAgentDirectory.areMultiplePropertiesPresent(objectArray)) {
            throw new ConfigurationException("multiple agent properties are present: only one of\n  * 'agentDir',\n  * 'agentZip', or\n  * 'agentDownload'\ncan be configured.\n", new Object[0]);
        }
        if (agentDir != null && !agentDir.isEmpty()) {
            File configuredAgentDir = new File(agentDir);
            preparedAgentDir = configuredAgentDir.getAbsolutePath().endsWith("graalnative") ? configuredAgentDir.getParentFile() : configuredAgentDir;
        } else if (agentZip != null && !agentZip.isEmpty()) {
            File dynatraceAgentZip = new File(agentZip);
            File extractDir = new File(project.getBuild().getDirectory(), "tmp");
            preparedAgentDir = extractDir;
            if (!preparedAgentDir.exists()) {
                DynatraceAgentDirectory.extractZip(dynatraceAgentZip.toPath(), extractDir.toPath(), logger);
            }
        } else if (agentDownload.isPresent()) {
            String environmentUrl = agentDownload.getEnvironmentUrl();
            if (environmentUrl == null || environmentUrl.isEmpty()) {
                throw new ConfigurationException("agentDownload: 'environmentUrl' has to be configured.", new Object[0]);
            }
            String apiToken = agentDownload.getApiToken();
            if (apiToken == null || apiToken.isEmpty()) {
                throw new ConfigurationException("agentDownload: 'apiToken' has to be configured.", new Object[0]);
            }
            String agentVersion = DynatraceAgentDirectory.getOneAgentInstallerVersion(agentDownload.getAgentVersion(), environmentUrl, apiToken, logger);
            logger.info("Using OneAgent installer version '%s'", agentVersion);
            File agentDownloadCacheDir = new File(topLevelProject.getBasedir(), ".dynatrace");
            File agentInstallerDir = new File(agentDownloadCacheDir, DynatraceAgentDirectoryUtils.getOneAgentInstallerCacheDirName(agentVersion));
            if (!agentInstallerDir.exists()) {
                logger.info("OneAgent installer for version '%s' doesn't exist", agentVersion);
                File downloadDir = new File(topLevelProject.getBuild().getDirectory(), "tmp");
                String installerZipName = DynatraceAgentDirectoryUtils.getOneAgentInstallerZipName(agentVersion);
                File installerZip = new File(downloadDir, installerZipName);
                if (!installerZip.exists()) {
                    logger.info("Downloading OneAgent installer for version '%s'", agentVersion);
                    DynatraceRestApi.downloadOneAgentInstaller(environmentUrl, apiToken, agentVersion, downloadDir.toPath(), installerZipName);
                }
                DynatraceAgentDirectory.extractZip(installerZip.toPath(), agentInstallerDir.toPath(), logger);
            }
            preparedAgentDir = agentInstallerDir;
        } else {
            DynatraceProperties dynatraceProperties = new DynatraceProperties(project.getProperties());
            String agentDirProperty = dynatraceProperties.getAgentDir();
            if (agentDirProperty != null) {
                throw new ConfigurationException("property '%s' is no longer supported; please use\n\t<configuration>\n\t\t<agentDir>%s</agentDir>\n\t</configuration>\nFor more information, go to https://docs.dynatrace.com/docs/setup-and-configuration/technology-support/application-software/java/graalvm-native-image#maven\n", "dynatrace.agent.dir", agentDirProperty);
            }
            String agentZipProperty = dynatraceProperties.getAgentZip();
            if (agentZipProperty != null) {
                throw new ConfigurationException("property '%s' is no longer supported; please use\n\t<configuration>\n\t\t<agentZip>%s</agentZip>\n\t</configuration>\nFor more information, go to https://docs.dynatrace.com/docs/setup-and-configuration/technology-support/application-software/java/graalvm-native-image#maven\n", "dynatrace.agent.zip", agentZipProperty);
            }
            throw new ConfigurationException("missing agent property: either\n  * 'agentDir',\n  * 'agentZip', or\n  * 'agentDownload' with 'environmentUrl' and 'apiToken'\nhas to be configured.\n", new Object[0]);
        }
        DynatraceAgentDirectoryUtils.checkAgentDirStructure(preparedAgentDir);
        logger.info("Prepared Dynatrace agent directory: '%s'", preparedAgentDir);
        return preparedAgentDir;
    }

    private static void extractZip(Path archive, Path destination, DynatraceLogger logger) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(Files.newInputStream(archive, new OpenOption[0]));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                Optional<Path> sanitizedPath = DynatraceAgentDirectory.sanitizePath(zipEntry, destination);
                if (sanitizedPath.isEmpty()) {
                    logger.warn("invalid zip entry '%s' in archive '%s'", zipEntry.getName(), archive);
                } else {
                    Path zipEntryPath = sanitizedPath.get();
                    if (zipEntry.isDirectory()) {
                        Files.createDirectories(zipEntryPath, new FileAttribute[0]);
                    } else {
                        Path zipEntryParentPath = zipEntryPath.getParent();
                        if (zipEntryParentPath != null && !Files.exists(zipEntryParentPath, new LinkOption[0])) {
                            Files.createDirectories(zipEntryParentPath, new FileAttribute[0]);
                        }
                        Files.copy(zipInputStream, zipEntryPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    zipInputStream.closeEntry();
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
    }

    private static String getOneAgentInstallerVersion(String configuredAgentVersion, String environmentUrl, String apiToken, DynatraceLogger logger) throws DownloadException {
        if (configuredAgentVersion != null && !configuredAgentVersion.isEmpty()) {
            return configuredAgentVersion;
        }
        logger.info("No OneAgent installer version configured -> using latest", new Object[0]);
        return DynatraceRestApi.getLatestOneAgentInstallerVersion(environmentUrl, apiToken);
    }

    private static Optional<Path> sanitizePath(ZipEntry entry, Path destination) {
        Path normalizedPath = destination.resolve(entry.getName()).normalize();
        if (!normalizedPath.startsWith(destination)) {
            return Optional.empty();
        }
        return Optional.of(normalizedPath);
    }

    private static boolean areMultiplePropertiesPresent(Object ... properties) {
        long numPresentProperties = Arrays.stream(properties).filter(Objects::nonNull).count();
        return numPresentProperties > 1L;
    }

    private DynatraceAgentDirectory() {
    }
}

