/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative;

import com.dynatrace.buildtools.graalnative.DynatraceLogger;
import com.dynatrace.buildtools.graalnative.PluginUtils;
import com.dynatrace.buildtools.graalnative.Xpp3DomUtils;
import com.dynatrace.buildtools.graalnative.shared.BuildArgs;
import com.dynatrace.buildtools.graalnative.shared.Constants;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="dynatrace-native-build-tools")
public class DynatraceNativeImageExtension
extends AbstractMavenLifecycleParticipant
implements LogEnabled {
    private DynatraceLogger logger;

    public void enableLogging(Logger logger) {
        this.logger = DynatraceLogger.of(logger);
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        for (MavenProject project : session.getProjects()) {
            Plugin quarkusPlugin;
            Plugin graalNativePlugin = PluginUtils.getGraalVmPlugin(project);
            if (graalNativePlugin != null) {
                this.logger.info("Detected GraalVM native-image plugin", new Object[0]);
            }
            if ((quarkusPlugin = PluginUtils.getQuarkusPlugin(project)) != null) {
                this.logger.info("Detected Quarkus plugin", new Object[0]);
            }
            if (graalNativePlugin == null && quarkusPlugin == null) {
                throw new MavenExecutionException("Failed to configure project for Dynatrace agent: project doesn't use GraalVM or Quarkus plugin", project.getFile());
            }
            if (graalNativePlugin == null) continue;
            String preparedAgentDirProperty = String.format("${%s}", "dynatrace.agent.preparedDir");
            Path buildAgentLib = Path.of(preparedAgentDirProperty, Constants.BUILD_AGENT_LIB_PATH);
            Path oneagentGraalNativeFeatureJar = Path.of(preparedAgentDirProperty, "graalnative/buildtime/any/java/oneagent-graalnative-feature.jar");
            String agentOptions = String.format("${%s}", "dynatrace.agent.options");
            Xpp3Dom graalNativePluginConfig = (Xpp3Dom)graalNativePlugin.getConfiguration();
            if (graalNativePluginConfig == null) {
                graalNativePluginConfig = new Xpp3Dom("configuration");
                graalNativePlugin.setConfiguration((Object)graalNativePluginConfig);
            }
            DynatraceNativeImageExtension.addAgentConfiguration(graalNativePluginConfig, buildAgentLib, oneagentGraalNativeFeatureJar, agentOptions);
            for (PluginExecution pluginExecution : graalNativePlugin.getExecutions()) {
                Xpp3Dom pluginExecutionConfig = (Xpp3Dom)pluginExecution.getConfiguration();
                if (pluginExecutionConfig == null) {
                    pluginExecutionConfig = new Xpp3Dom("configuration");
                    pluginExecution.setConfiguration((Object)pluginExecutionConfig);
                }
                DynatraceNativeImageExtension.addAgentConfiguration(pluginExecutionConfig, buildAgentLib, oneagentGraalNativeFeatureJar, agentOptions);
            }
        }
    }

    private static void addAgentConfiguration(Xpp3Dom configuration, Path buildAgentLib, Path oneagentGraalNativeFeatureJar, String agentOptions) {
        List<String> buildArgs = BuildArgs.getBuildArgs(oneagentGraalNativeFeatureJar.toString());
        Xpp3Dom buildArgsDom = Xpp3DomUtils.getOrAddChild(configuration, "buildArgs");
        for (String buildArg : buildArgs) {
            Xpp3Dom buildArgDom = new Xpp3Dom("buildArg");
            buildArgDom.setValue(buildArg);
            buildArgsDom.addChild(buildArgDom);
        }
        String agentPath = BuildArgs.getAgentPath(buildAgentLib.toString(), agentOptions);
        Xpp3Dom jvmArgs = Xpp3DomUtils.getOrAddChild(configuration, "jvmArgs");
        Xpp3Dom agentPathArg = new Xpp3Dom("jvmArg");
        agentPathArg.setValue(agentPath);
        jvmArgs.addChild(agentPathArg);
    }
}

