/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative;

import com.dynatrace.buildtools.graalnative.AgentDownload;
import com.dynatrace.buildtools.graalnative.ConfigurationException;
import com.dynatrace.buildtools.graalnative.DynatraceAgentDirectory;
import com.dynatrace.buildtools.graalnative.DynatraceLogger;
import com.dynatrace.buildtools.graalnative.DynatraceProperties;
import com.dynatrace.buildtools.graalnative.PluginUtils;
import com.dynatrace.buildtools.graalnative.shared.BuildArgs;
import com.dynatrace.buildtools.graalnative.shared.Constants;
import com.dynatrace.buildtools.graalnative.shared.DownloadException;
import java.io.File;
import java.io.IOException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="setup-build-agent", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class SetupBuildAgentMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="agentDir")
    private String agentDir;
    @Parameter(property="agentZip")
    private String agentZip;
    @Parameter(property="agentDownload", defaultValue="none")
    private AgentDownload agentDownload;
    @Parameter(property="agentOptions")
    private String agentOptions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            DynatraceLogger logger = DynatraceLogger.of(this.getLog());
            File preparedAgentDir = DynatraceAgentDirectory.setup(this.agentDir, this.agentZip, this.agentDownload, this.project, this.session.getTopLevelProject(), logger);
            DynatraceProperties dynatraceProperties = new DynatraceProperties(this.project.getProperties());
            dynatraceProperties.setPreparedAgentDir(preparedAgentDir.getAbsolutePath());
            dynatraceProperties.setAgentOptions(this.agentOptions);
            this.session.getAllProjects().forEach(mavenProject -> {
                DynatraceProperties dtProperties = new DynatraceProperties(mavenProject.getProperties());
                dtProperties.setPreparedAgentDir(preparedAgentDir.getAbsolutePath());
                dtProperties.setAgentOptions(this.agentOptions);
            });
            Plugin quarkusPlugin = PluginUtils.getQuarkusPlugin(this.project);
            if (quarkusPlugin != null) {
                File buildAgentLib = new File(preparedAgentDir, Constants.BUILD_AGENT_LIB_PATH);
                File oneagentGraalNativeFeatureJar = new File(preparedAgentDir, "graalnative/buildtime/any/java/oneagent-graalnative-feature.jar");
                String existingAdditionalBuildArgs = this.project.getProperties().getProperty("quarkus.native.additional-build-args");
                String additionalBuildArgs = BuildArgs.getQuarkusBuildArgs(existingAdditionalBuildArgs, buildAgentLib, oneagentGraalNativeFeatureJar, this.agentOptions);
                this.project.getProperties().setProperty("quarkus.native.additional-build-args", additionalBuildArgs);
            }
        }
        catch (ConfigurationException | DownloadException | IOException e) {
            throw new MojoExecutionException("Failed to set up the Dynatrace agent directory", e);
        }
    }
}

