/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative.shared;

public final class Constants {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final boolean IS_WINDOWS = OS_NAME.toLowerCase().startsWith("win");
    public static final boolean IS_ARM = Constants.isArm(OS_ARCH);
    public static final String BUILD_AGENT_LIB_NAME = IS_WINDOWS ? "oneagentgraalnativebuildtime.dll" : "liboneagentgraalnativebuildtime.so";
    public static final String BUILD_AGENT_LIB_PATH = "graalnative/buildtime/lib64/" + BUILD_AGENT_LIB_NAME;
    public static final String RUNTIME_AGENT_LIB_NAME = IS_WINDOWS ? "oneagentgraalnativeruntime.dll" : "liboneagentgraalnativeruntime.so";
    public static final String RUNTIME_AGENT_LIB_PATH = "graalnative/runtime/" + RUNTIME_AGENT_LIB_NAME;
    public static final String ONEAGENT_FEATURE_JAR_NAME = "oneagent-graalnative-feature.jar";
    public static final String ONEAGENT_FEATURE_JAR_PATH = "graalnative/buildtime/any/java/oneagent-graalnative-feature.jar";
    public static final String ONEAGENT_FEATURE_FQN = "com.dynatrace.graalnative.features.OneAgentGraalNativeFeature";
    public static final String AGENT_DOWNLOAD_CACHE_DIRECTORY_NAME = ".dynatrace";
    public static final String QUARKUS_PACKAGE_TYPE = "quarkus.package.type";
    public static final String QUARKUS_NATIVE_ADDITIONAL_BUILD_ARGS = "quarkus.native.additional-build-args";

    private static boolean isArm(String arch) {
        return arch.equalsIgnoreCase("aarch64");
    }

    private Constants() {
    }
}

