/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative.shared;

import com.dynatrace.buildtools.graalnative.shared.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;

public final class DynatraceAgentDirectoryUtils {
    private static final List<String> EXPECTED_AGENT_DIR_ENTRIES = List.of(Constants.RUNTIME_AGENT_LIB_PATH, Constants.BUILD_AGENT_LIB_PATH, "graalnative/buildtime/any/java/oneagent-graalnative-feature.jar", "graalnative/buildtime/any/java/oneagentjava.jar", "graalnative/buildtime/any/java/oneagentjava.8.jar", "graalnative/buildtime/any/java/oneagentjava.11.jar", "graalnative/buildtime/any/java/oneagentjava.17.jar", "graalnative/buildtime/any/java/oneagentjava.rmi.jar", "graalnative/buildtime/any/java/oneagentjava.sql.jar", "graalnative/buildtime/any/java/oneagentjava.addons.jar", "graalnative/buildtime/any/java/ruleset");

    public static void checkAgentDirStructure(File agentDir) throws FileNotFoundException {
        if (!agentDir.exists()) {
            throw new FileNotFoundException(agentDir.getAbsolutePath());
        }
        for (String entry : EXPECTED_AGENT_DIR_ENTRIES) {
            File entryFile = new File(agentDir, entry);
            if (entryFile.exists()) continue;
            throw new FileNotFoundException(entryFile.getAbsolutePath());
        }
    }

    public static String getOneAgentInstallerZipName(String agentVersion) {
        return String.format("oneagent-installer-%s.zip", agentVersion);
    }

    public static String getOneAgentInstallerCacheDirName(String agentVersion) {
        return String.format("oneagent-%s", agentVersion);
    }

    private DynatraceAgentDirectoryUtils() {
    }
}

