/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative;

import com.dynatrace.buildtools.graalnative.extension.AbstractDynatraceNativeImageExtension;
import com.dynatrace.buildtools.graalnative.extension.DynatraceNativeImageExtension;
import com.dynatrace.buildtools.graalnative.internal.DynatraceLogger;
import com.dynatrace.buildtools.graalnative.internal.TaskUtils;
import com.dynatrace.buildtools.graalnative.tasks.DynatraceNativeCompileTask;
import com.dynatrace.buildtools.graalnative.tasks.PrepareDynatraceAgentTask;
import com.dynatrace.buildtools.graalnative.tasks.RuntimeAgentCopyTask;
import org.graalvm.buildtools.gradle.tasks.BuildNativeImageTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public class DynatraceNativeImagePlugin
implements Plugin<Project> {
    public static final String GRAALVM_NATIVE_IMAGE_PLUGIN_NAME = "org.graalvm.buildtools.native";
    public static final String QUARKUS_PLUGIN_NAME = "io.quarkus";
    private static final String DYNATRACE_EXTENSION_NAME = "dynatrace";
    private static final String PREPARE_DYNATRACE_AGENT_TASK_NAME = "prepareDynatraceAgent";
    private static final String DYNATRACE_NATIVE_COMPILE_TASK_NAME = "dynatraceNativeCompile";
    private static final String COPY_RUNTIME_AGENT_TASK_NAME = "copyDynatraceRuntimeAgent";

    public void apply(Project project) {
        boolean hasQuarkusPlugin;
        DynatraceLogger logger = DynatraceLogger.of(project.getLogger());
        boolean hasGraalVmNativeImagePlugin = project.getPlugins().hasPlugin(GRAALVM_NATIVE_IMAGE_PLUGIN_NAME);
        if (hasGraalVmNativeImagePlugin) {
            logger.info("Detected GraalVM native-image plugin '{}'", GRAALVM_NATIVE_IMAGE_PLUGIN_NAME);
        }
        if (hasQuarkusPlugin = project.getPlugins().hasPlugin(QUARKUS_PLUGIN_NAME)) {
            logger.info("Detected Quarkus plugin '{}'", QUARKUS_PLUGIN_NAME);
        }
        if (!hasGraalVmNativeImagePlugin && !hasQuarkusPlugin) {
            throw new UnsupportedOperationException();
        }
        DynatraceNativeImageExtension dynatraceExtension = (DynatraceNativeImageExtension)project.getExtensions().create(DYNATRACE_EXTENSION_NAME, AbstractDynatraceNativeImageExtension.class, new Object[0]);
        TaskProvider prepareDynatraceAgentTaskProvider = project.getTasks().register(PREPARE_DYNATRACE_AGENT_TASK_NAME, PrepareDynatraceAgentTask.class, task -> {
            task.getAgentDir().set(dynatraceExtension.getAgentDir().map(agentDir -> project.getLayout().getProjectDirectory().dir(agentDir)));
            task.getAgentZip().set(dynatraceExtension.getAgentZip().map(agentZip -> project.getLayout().getProjectDirectory().file(agentZip)));
            task.getAgentDownload().set(dynatraceExtension.getAgentDownload());
        });
        TaskProvider runtimeAgentCopyTaskProvider = project.getTasks().register(COPY_RUNTIME_AGENT_TASK_NAME, RuntimeAgentCopyTask.class, task -> {
            task.getPreparedAgentDirectory().set((Provider)((PrepareDynatraceAgentTask)((Object)((Object)prepareDynatraceAgentTaskProvider.get()))).getPreparedAgentDir());
            task.dependsOn(new Object[]{prepareDynatraceAgentTaskProvider});
            if (hasQuarkusPlugin) {
                TaskProvider buildTaskProvider = project.getTasks().named("build");
                task.getNativeImageOutputDirectory().set((Provider)project.getLayout().getBuildDirectory());
                task.mustRunAfter(new Object[]{buildTaskProvider});
            } else {
                TaskProvider buildNativeImageTaskProvider = project.getTasks().named("nativeCompile", BuildNativeImageTask.class);
                task.getNativeImageOutputDirectory().set((Provider)((BuildNativeImageTask)buildNativeImageTaskProvider.get()).getOutputDirectory());
                task.mustRunAfter(new Object[]{buildNativeImageTaskProvider});
            }
        });
        project.getTasks().register(DYNATRACE_NATIVE_COMPILE_TASK_NAME, DynatraceNativeCompileTask.class, task -> {
            task.getPreparedAgentDirectory().set((Provider)((PrepareDynatraceAgentTask)((Object)((Object)prepareDynatraceAgentTaskProvider.get()))).getPreparedAgentDir());
            task.getAgentOptions().set(dynatraceExtension.getAgentOptions());
            task.getAdditionalBuildArgs().set(dynatraceExtension.getAdditionalBuildArgs());
            task.dependsOn(new Object[]{prepareDynatraceAgentTaskProvider});
            if (hasQuarkusPlugin) {
                TaskProvider buildTaskProvider = project.getTasks().named("build");
                task.finalizedBy(new Object[]{buildTaskProvider, runtimeAgentCopyTaskProvider});
                String existingPackageType = System.getProperty("quarkus.package.type");
                if (existingPackageType != null) {
                    logger.info("Setting '{}' to 'native', previous value was '{}'", "quarkus.package.type", existingPackageType);
                } else {
                    logger.info("Setting '{}' to 'native'", "quarkus.package.type");
                }
                System.setProperty("quarkus.package.type", "native");
                ((Task)buildTaskProvider.get()).onlyIf(buildTask -> task.getState().getFailure() == null);
                TaskUtils.getAllDependingTasks((Task)buildTaskProvider.get()).forEach(dependingTask -> dependingTask.onlyIf(t -> task.getState().getFailure() == null));
            } else {
                TaskProvider buildNativeImageTaskProvider = project.getTasks().named("nativeCompile", BuildNativeImageTask.class);
                task.finalizedBy(new Object[]{buildNativeImageTaskProvider, runtimeAgentCopyTaskProvider});
                ((BuildNativeImageTask)buildNativeImageTaskProvider.get()).onlyIf(buildTask -> task.getState().getFailure() == null);
                TaskUtils.getAllDependingTasks((Task)buildNativeImageTaskProvider.get()).forEach(dependingTask -> dependingTask.onlyIf(t -> task.getState().getFailure() == null));
            }
            ((RuntimeAgentCopyTask)((Object)((Object)runtimeAgentCopyTaskProvider.get()))).onlyIf(copyTask -> task.getState().getFailure() == null);
        });
    }
}

