/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative.shared;

import com.dynatrace.buildtools.graalnative.shared.DownloadException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public final class DownloadUtils {
    public static String downloadJson(URI uri, Map<String, String> headers) throws DownloadException {
        try {
            HashMap<String, String> allHeaders = new HashMap<String, String>(headers);
            allHeaders.put("accept", "application/json");
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofMinutes(2L));
            allHeaders.forEach(requestBuilder::setHeader);
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<InputStream> response = client.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() != 200) {
                throw new DownloadException(String.format("Failed to download '%s': %d", uri, response.statusCode()));
            }
            return DownloadUtils.getResponseBodyText(response);
        }
        catch (IOException | InterruptedException e) {
            throw new DownloadException(String.format("Failed to download '%s'", uri), e);
        }
    }

    /*
     * Exception decompiling
     */
    private static String getResponseBodyText(HttpResponse<InputStream> response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File downloadFile(URI uri, Map<String, String> headers, Path destination, String fileName) throws DownloadException {
        try {
            HashMap<String, String> allHeaders = new HashMap<String, String>(headers);
            allHeaders.put("accept", "application/octet-stream");
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofMinutes(2L));
            allHeaders.forEach(requestBuilder::setHeader);
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<InputStream> response = client.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() != 200) {
                throw new DownloadException(String.format("Failed to download '%s': %d", uri, response.statusCode()));
            }
            if (!Files.exists(destination, new LinkOption[0])) {
                Files.createDirectories(destination, new FileAttribute[0]);
            }
            Path result = destination.resolve(fileName);
            Files.copy(response.body(), result, StandardCopyOption.REPLACE_EXISTING);
            return result.toFile();
        }
        catch (IOException | InterruptedException e) {
            throw new DownloadException(String.format("Failed to download '%s'", uri), e);
        }
    }

    private DownloadUtils() {
    }
}

