/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative.shared;

import com.dynatrace.buildtools.graalnative.shared.Constants;
import com.dynatrace.buildtools.graalnative.shared.DownloadException;
import com.dynatrace.buildtools.graalnative.shared.DownloadUtils;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Map;

public final class DynatraceRestApi {
    public static String getLatestOneAgentInstallerVersion(String environmentUrl, String apiToken) throws DownloadException {
        try {
            String agentVersionJson = DownloadUtils.downloadJson(URI.create(DynatraceRestApi.getLatestOneAgentInstallerVersionUrl(environmentUrl)), Map.of("Authorization", "Api-Token " + apiToken));
            return DynatraceRestApi.extractAgentVersion(agentVersionJson);
        }
        catch (IllegalArgumentException e) {
            throw new DownloadException(String.format("Failed to get latest OneAgent installer version from '%s'", environmentUrl), e);
        }
    }

    private static String extractAgentVersion(String agentVersionJson) {
        int delimiterIndex = agentVersionJson.indexOf(58);
        if (delimiterIndex == -1) {
            return null;
        }
        int agentVersionStartIndex = delimiterIndex + 2;
        int agentVersionEndIndex = agentVersionJson.indexOf(34, agentVersionStartIndex);
        if (agentVersionEndIndex == -1) {
            return null;
        }
        return agentVersionJson.substring(agentVersionStartIndex, agentVersionEndIndex);
    }

    private static String getLatestOneAgentInstallerVersionUrl(String environmentUrl) {
        String osType = Constants.IS_WINDOWS ? "windows" : "unix";
        String arch = Constants.IS_ARM ? "arm" : "x86";
        String bitness = "64";
        return String.format("%s/api/v1/deployment/installer/agent/%s/paas/latest/metainfo?flavor=default&arch=%s&bitness=%s", environmentUrl, osType, arch, "64");
    }

    public static File downloadOneAgentInstaller(String environmentUrl, String apiToken, String agentVersion, Path destination, String installerFileName) throws DownloadException {
        try {
            return DownloadUtils.downloadFile(URI.create(DynatraceRestApi.getOneAgentInstallerUrl(environmentUrl, agentVersion)), Map.of("Authorization", "Api-Token " + apiToken), destination, installerFileName);
        }
        catch (IllegalArgumentException e) {
            throw new DownloadException(String.format("Failed to download OneAgent installer from '%s' for agent version '%s'", environmentUrl, DynatraceRestApi.isValidAgentVersion(agentVersion) ? agentVersion : "latest"), e);
        }
    }

    private static String getOneAgentInstallerUrl(String environmentUrl, String agentVersion) {
        String osType = Constants.IS_WINDOWS ? "windows" : "unix";
        String arch = Constants.IS_ARM ? "arm" : "x86";
        String bitness = "64";
        if (DynatraceRestApi.isValidAgentVersion(agentVersion)) {
            return String.format("%s/api/v1/deployment/installer/agent/%s/paas/version/%s?flavor=default&arch=%s&bitness=%s&include=java-graal-native", environmentUrl, osType, agentVersion, arch, "64");
        }
        return String.format("%s/api/v1/deployment/installer/agent/%s/paas/latest?flavor=default&arch=%s&bitness=%s&include=java-graal-native", environmentUrl, osType, arch, "64");
    }

    private static boolean isValidAgentVersion(String agentVersion) {
        return agentVersion != null && !agentVersion.isBlank();
    }

    private DynatraceRestApi() {
    }
}

