/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative.tasks;

import com.dynatrace.buildtools.graalnative.internal.DynatraceLogger;
import com.dynatrace.buildtools.graalnative.shared.BuildArgs;
import com.dynatrace.buildtools.graalnative.shared.Constants;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.buildtools.gradle.dsl.GraalVMExtension;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;

public abstract class DynatraceNativeCompileTask
extends DefaultTask {
    @InputDirectory
    public abstract DirectoryProperty getPreparedAgentDirectory();

    @Input
    @Optional
    public abstract Property<String> getAgentOptions();

    @Input
    @Optional
    public abstract ListProperty<String> getAdditionalBuildArgs();

    @TaskAction
    public void run() {
        DynatraceLogger logger = DynatraceLogger.of(this.getLogger());
        RegularFile buildAgentLib = ((Directory)this.getPreparedAgentDirectory().get()).file(Constants.BUILD_AGENT_LIB_PATH);
        RegularFile oneagentGraalNativeFeatureJar = ((Directory)this.getPreparedAgentDirectory().get()).file("graalnative/buildtime/any/java/oneagent-graalnative-feature.jar");
        List additionalBuildArgs = (List)this.getAdditionalBuildArgs().getOrNull();
        boolean hasGraalVmNativeImagePlugin = this.getProject().getPlugins().hasPlugin("org.graalvm.buildtools.native");
        boolean hasQuarkusPlugin = this.getProject().getPlugins().hasPlugin("io.quarkus");
        if (hasGraalVmNativeImagePlugin) {
            GraalVMExtension graalvmExtension = (GraalVMExtension)this.getProject().getExtensions().findByType(GraalVMExtension.class);
            logger.info("Using GraalVMExtension to configure the native-image build", new Object[0]);
            NativeImageOptions mainNativeImageOptions = (NativeImageOptions)graalvmExtension.getBinaries().maybeCreate("main");
            ArrayList<String> buildArgs = new ArrayList<String>(BuildArgs.getBuildArgs(oneagentGraalNativeFeatureJar.getAsFile().getAbsolutePath()));
            if (additionalBuildArgs != null) {
                buildArgs.addAll(additionalBuildArgs);
            }
            mainNativeImageOptions.buildArgs(buildArgs);
            Property<String> agentOptions = this.getAgentOptions();
            String agentPath = BuildArgs.getAgentPath(buildAgentLib.getAsFile().getAbsolutePath(), (String)agentOptions.getOrNull());
            mainNativeImageOptions.jvmArgs(List.of(agentPath));
        } else if (hasQuarkusPlugin) {
            String existingAdditionalBuildArgs;
            logger.info("Using system properties to configure the native-image build", new Object[0]);
            String existingPackageType = System.getProperty("quarkus.package.type");
            if (existingPackageType != null && !existingPackageType.equals("native")) {
                logger.warn("Overwriting existing value '{}' of system property '{}' with 'native'", existingPackageType, "quarkus.package.type");
                System.setProperty("quarkus.package.type", "native");
            }
            if ((existingAdditionalBuildArgs = System.getProperty("quarkus.native.additional-build-args")) != null) {
                logger.info("Found existing '{}': '{}'", "quarkus.native.additional-build-args", existingAdditionalBuildArgs);
            }
            Property<String> agentOptions = this.getAgentOptions();
            String quarkusAdditionalBuildArgs = BuildArgs.getQuarkusBuildArgs(existingAdditionalBuildArgs, buildAgentLib.getAsFile(), oneagentGraalNativeFeatureJar.getAsFile(), (String)agentOptions.getOrNull(), additionalBuildArgs);
            System.setProperty("quarkus.native.additional-build-args", quarkusAdditionalBuildArgs);
            TaskProvider quarkusBuildCacheableAppPartsTaskProvider = this.getProject().getTasks().named("quarkusAppPartsBuild");
            ((Task)quarkusBuildCacheableAppPartsTaskProvider.get()).getInputs().property("dynatrace-additional-build-args", (Object)quarkusAdditionalBuildArgs);
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

