/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative.tasks;

import com.dynatrace.buildtools.graalnative.extension.AgentDownload;
import com.dynatrace.buildtools.graalnative.internal.ConfigurationException;
import com.dynatrace.buildtools.graalnative.internal.DynatraceLogger;
import com.dynatrace.buildtools.graalnative.shared.DownloadException;
import com.dynatrace.buildtools.graalnative.shared.DynatraceAgentDirectoryUtils;
import com.dynatrace.buildtools.graalnative.shared.DynatraceRestApi;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class PrepareDynatraceAgentTask
extends DefaultTask {
    @InputDirectory
    @Optional
    public abstract DirectoryProperty getAgentDir();

    @InputFile
    @Optional
    public abstract RegularFileProperty getAgentZip();

    @Nested
    @Optional
    public abstract Property<AgentDownload> getAgentDownload();

    @Internal
    public abstract DirectoryProperty getPreparedAgentDir();

    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @Inject
    protected abstract ArchiveOperations getArchiveOperations();

    @TaskAction
    public void prepareAgent() throws IOException, DownloadException {
        Directory preparedAgentDir;
        if (PrepareDynatraceAgentTask.areMultiplePropertiesPresent(new Property[]{this.getAgentDir(), this.getAgentZip(), this.getAgentDownload()})) {
            throw new ConfigurationException("multiple agent properties are present: only one of\n  * 'agentDir',\n  * 'agentZip', or\n  * 'agentDownload'\ncan be configured.\n");
        }
        Project rootProject = this.getProject().getRootProject();
        DynatraceLogger logger = DynatraceLogger.of(this.getLogger());
        if (this.getAgentDir().isPresent()) {
            String md5;
            Directory configuredAgentDir = (Directory)this.getAgentDir().get();
            Directory agentDir = configuredAgentDir.getAsFile().getAbsolutePath().endsWith("graalnative") ? configuredAgentDir.dir("..") : configuredAgentDir;
            Directory buildDir = (Directory)rootProject.getLayout().getBuildDirectory().get();
            preparedAgentDir = buildDir.dir("tmp/dt-graalnative-" + (md5 = PrepareDynatraceAgentTask.getMd5(agentDir)).substring(md5.length() / 2));
            if (!preparedAgentDir.getAsFile().exists()) {
                this.getFileSystemOperations().copy(copySpec -> {
                    copySpec.from(new Object[]{agentDir});
                    copySpec.into((Object)preparedAgentDir);
                });
            }
        } else if (this.getAgentZip().isPresent()) {
            String md5;
            RegularFile agentZip = (RegularFile)this.getAgentZip().get();
            Directory buildDir = (Directory)rootProject.getLayout().getBuildDirectory().get();
            Directory extractDir = buildDir.dir("tmp");
            preparedAgentDir = extractDir.dir("dt-graalnative-" + (md5 = PrepareDynatraceAgentTask.getMd5(agentZip)).substring(md5.length() / 2));
            if (!preparedAgentDir.getAsFile().exists()) {
                this.getFileSystemOperations().copy(copySpec -> {
                    copySpec.from(new Object[]{this.getArchiveOperations().zipTree((Object)agentZip)}).include(new String[]{"agent/**"}).include(new String[]{"graalnative/**"});
                    copySpec.into((Object)preparedAgentDir);
                });
            }
        } else if (this.getAgentDownload().isPresent()) {
            AgentDownload agentDownload = (AgentDownload)this.getAgentDownload().get();
            Property<String> environmentUrl = agentDownload.getEnvironmentUrl();
            if (!environmentUrl.isPresent()) {
                throw new ConfigurationException("agentDownload: 'environmentUrl' has to be configured.");
            }
            Property<String> apiToken = agentDownload.getApiToken();
            if (!apiToken.isPresent()) {
                throw new ConfigurationException("agentDownload: 'apiToken' has to be configured.");
            }
            String agentVersion = PrepareDynatraceAgentTask.getOneAgentInstallerVersion(agentDownload.getAgentVersion(), (String)environmentUrl.get(), (String)apiToken.get(), logger);
            logger.info("Using OneAgent installer version '{}'", agentVersion);
            Directory agentDownloadCacheDir = rootProject.getLayout().getProjectDirectory().dir(".dynatrace");
            Directory agentInstallerDir = agentDownloadCacheDir.dir(DynatraceAgentDirectoryUtils.getOneAgentInstallerCacheDirName(agentVersion));
            if (!agentInstallerDir.getAsFile().exists()) {
                logger.info("OneAgent installer for version '{}' doesn't exist", agentVersion);
                Directory buildDir = (Directory)rootProject.getLayout().getBuildDirectory().get();
                Directory downloadDir = buildDir.dir("tmp");
                String installerZipName = DynatraceAgentDirectoryUtils.getOneAgentInstallerZipName(agentVersion);
                Directory installerZip = downloadDir.dir(installerZipName);
                if (!installerZip.getAsFile().exists()) {
                    logger.info("Downloading OneAgent installer for version '{}'", agentVersion);
                    DynatraceRestApi.downloadOneAgentInstaller((String)environmentUrl.get(), (String)apiToken.get(), agentVersion, downloadDir.getAsFile().toPath(), installerZipName);
                }
                this.getFileSystemOperations().copy(copySpec -> {
                    copySpec.from(new Object[]{this.getArchiveOperations().zipTree((Object)installerZip)});
                    copySpec.into((Object)agentInstallerDir);
                });
            }
            preparedAgentDir = agentInstallerDir;
        } else {
            throw new ConfigurationException("missing agent property: either\n  * 'agentDir',\n  * 'agentZip', or\n  * 'agentDownload' with 'environmentUrl' and 'apiToken'\nhas to be configured.\n");
        }
        DynatraceAgentDirectoryUtils.checkAgentDirStructure(preparedAgentDir.getAsFile());
        logger.info("Prepared Dynatrace agent directory: {}", preparedAgentDir);
        this.getPreparedAgentDir().set((Object)preparedAgentDir);
    }

    private static String getOneAgentInstallerVersion(Property<String> configuredAgentVersion, String environmentUrl, String apiToken, DynatraceLogger logger) throws DownloadException {
        if (configuredAgentVersion.isPresent()) {
            return (String)configuredAgentVersion.get();
        }
        logger.info("No OneAgent installer version configured -> using latest", new Object[0]);
        return DynatraceRestApi.getLatestOneAgentInstallerVersion(environmentUrl, apiToken);
    }

    private static boolean areMultiplePropertiesPresent(Property<?> ... properties) {
        long numPresentProperties = Arrays.stream(properties).filter(property -> property.getOrNull() != null).count();
        return numPresentProperties > 1L;
    }

    private static String getMd5(Directory directory) throws IOException {
        MessageDigest md5 = DigestUtils.getMd5Digest();
        try (Stream fileStream = FileUtils.streamFiles((File)directory.getAsFile(), (boolean)true, (String[])null);){
            fileStream.forEach(file -> {
                try {
                    DigestUtils.updateDigest((MessageDigest)md5, (File)file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return Hex.encodeHexString((byte[])md5.digest());
    }

    private static String getMd5(RegularFile file) throws IOException {
        return new DigestUtils("MD5").digestAsHex(file.getAsFile());
    }
}

