/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative.tasks;

import java.io.IOException;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class RuntimeAgentCopyTask
extends DefaultTask {
    @InputDirectory
    public abstract DirectoryProperty getPreparedAgentDirectory();

    @Internal
    public abstract DirectoryProperty getNativeImageOutputDirectory();

    @OutputDirectory
    public DirectoryProperty getDestinationDirectory() {
        DirectoryProperty destinationDirectory = this.getProject().getObjects().directoryProperty();
        destinationDirectory.set(this.getNativeImageOutputDirectory().dir("dynatrace/agent"));
        return destinationDirectory;
    }

    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @TaskAction
    public void copy() throws IOException {
        this.getFileSystemOperations().copy(copySpec -> {
            copySpec.from(new Object[]{this.getPreparedAgentDirectory().dir("graalnative/runtime")}).include(fileTreeElement -> !fileTreeElement.isDirectory());
            copySpec.into((Object)this.getDestinationDirectory().dir("lib64"));
        });
        this.getFileSystemOperations().copy(copySpec -> {
            copySpec.from(new Object[]{this.getPreparedAgentDirectory().dir("graalnative/runtime/any")});
            copySpec.into((Object)this.getDestinationDirectory().dir("any"));
        });
        this.getFileSystemOperations().copy(copySpec -> {
            copySpec.from(new Object[]{this.getPreparedAgentDirectory().dir("graalnative/runtime/conf")});
            copySpec.into((Object)this.getDestinationDirectory().dir("conf"));
        });
        this.getFileSystemOperations().copy(copySpec -> {
            copySpec.from(new Object[]{this.getPreparedAgentDirectory().dir("agent/installer.version")});
            copySpec.into((Object)this.getDestinationDirectory());
        });
        ((Directory)this.getDestinationDirectory().get()).file("dt_fips_disabled.flag").getAsFile().createNewFile();
    }
}

