/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.CodePoints;

final class DimensionKeyValidator {
    private DimensionKeyValidator() {
    }

    static boolean isValidFirstSectionStartCharacter(int codePoint) {
        return codePoint >= CodePoints.A_LOWERCASE && codePoint <= CodePoints.Z_LOWERCASE || codePoint == CodePoints.UNDERSCORE;
    }

    static boolean isValidSection(int codePoint) {
        return DimensionKeyValidator.isValidFirstSectionStartCharacter(codePoint) || DimensionKeyValidator.isNumber(codePoint) || DimensionKeyValidator.isSpecialCharacter(codePoint);
    }

    static boolean isSectionSeparator(int codePoint) {
        return codePoint == CodePoints.DOT;
    }

    static boolean normalizationRequired(String key) {
        int codePoint;
        if (key == null || key.isEmpty()) {
            return true;
        }
        int length = key.length();
        if (length > 100) {
            return true;
        }
        State state = State.START;
        block4: for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = key.codePointAt(offset);
            switch (state) {
                case START: {
                    if (!DimensionKeyValidator.isValidFirstSectionStartCharacter(codePoint)) {
                        return true;
                    }
                    state = State.SECTION;
                    continue block4;
                }
                case SECTION: {
                    if (DimensionKeyValidator.isSectionSeparator(codePoint)) {
                        if (offset + Character.charCount(codePoint) == length) {
                            return true;
                        }
                        state = State.START;
                        continue block4;
                    }
                    if (DimensionKeyValidator.isValidSection(codePoint)) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isNumber(int codePoint) {
        return codePoint >= CodePoints.ZERO && codePoint <= CodePoints.NINE;
    }

    private static boolean isSpecialCharacter(int codePoint) {
        return codePoint == CodePoints.HYPHEN || codePoint == CodePoints.COLON;
    }

    static enum State {
        START,
        SECTION;

    }
}

