/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.file.util;

import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

abstract class FilePoller
implements Closeable {
    protected final Path absoluteFilePath;

    protected FilePoller(Path filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null.");
        }
        Path absPath = filename.toAbsolutePath();
        if (Files.isDirectory(absPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Passed path is a directory: %s", absPath));
        }
        if (!Files.exists(absPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("File does not exist: %s", absPath));
        }
        this.absoluteFilePath = absPath;
    }

    public abstract boolean fileContentsUpdated();

    public String getWatchedFilePath() {
        return this.absoluteFilePath.toString();
    }
}

