/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.file.util;

import com.dynatrace.file.util.FilePoller;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.zip.CRC32;

class PollBasedFilePoller
extends FilePoller {
    private static final Logger LOGGER = Logger.getLogger(PollBasedFilePoller.class.getName());
    private static final String LOG_MESSAGE_FAILED_FILE_READ = "Failed to read file %s. Error: %s";
    private final AtomicBoolean changedSinceLastInquiry = new AtomicBoolean(false);
    private final ScheduledFuture<?> worker;
    private final ScheduledExecutorService executorService;
    private final CRC32 crc32 = new CRC32();
    private Long prevChecksumValue = null;

    protected PollBasedFilePoller(Path filePath, Duration pollInterval) {
        super(filePath);
        if (pollInterval == null) {
            throw new IllegalArgumentException("Poll interval cannot be null");
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(null, r, "PollBasedFilePoller");
                t.setDaemon(true);
                return t;
            }
        });
        LOGGER.finer(() -> String.format("Polling every %dms", pollInterval.toMillis()));
        this.worker = this.executorService.scheduleAtFixedRate(this::poll, pollInterval.toNanos(), pollInterval.toNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public boolean fileContentsUpdated() {
        return this.changedSinceLastInquiry.getAndSet(false);
    }

    private synchronized void poll() {
        Long latestChecksumValue = this.getChecksumValue();
        if (latestChecksumValue != null) {
            if (!latestChecksumValue.equals(this.prevChecksumValue)) {
                this.changedSinceLastInquiry.set(true);
            }
            this.prevChecksumValue = latestChecksumValue;
        }
    }

    private synchronized Long getChecksumValue() {
        this.crc32.reset();
        try {
            byte[] fileBytes = Files.readAllBytes(this.absoluteFilePath);
            this.crc32.update(fileBytes, 0, fileBytes.length);
        }
        catch (IOException e) {
            LOGGER.warning(() -> String.format(LOG_MESSAGE_FAILED_FILE_READ, this.absoluteFilePath, e));
            return null;
        }
        return this.crc32.getValue();
    }

    @Override
    public void close() {
        this.worker.cancel(true);
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(50L, TimeUnit.MILLISECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.warning("failed to shut down poll based file poller: " + e);
        }
    }
}

