/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Constants;
import com.dynatrace.android.instrumentation.util.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientTransformerFactory
implements TransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"HttpClientTransformerFactory");
    private static final String HTTP_CLIENT = "org.apache.http.client.HttpClient";
    private static final String HTTP_REQUEST_BASE = "org.apache.http.client.methods.HttpRequestBase";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        try {
            ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
            instructionSensors.add(this.generateHttpClientSensors(classLoader));
            instructionSensors.add(this.generateHttpRequestBaseSensors(classLoader));
            return new DefaultSubTransformer("HttpClientTransformer", instructionSensors, new ArrayList<SensorGroup<MethodSensor>>(), classLoader, warningsAsErrors);
        }
        catch (ClassNotFoundException e) {
            logger.debug("Deactivate instrumentation for HttpClient web requests, because it is not part of the classpath");
            return null;
        }
    }

    private SensorGroup<InstructionSensor> generateHttpRequestBaseSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> request = Class.forName(HTTP_REQUEST_BASE, false, classLoader);
        Class<?> callback = Class.forName(Constants.APACHE_CALLBACK_DYNATRACE, false, classLoader);
        Method instr_newInstance = callback.getDeclaredMethod("newInstance", request);
        return new SensorGroupImpl<InstructionSensor>("HttpRequestBaseSensor", request, new InsertInstructionSensor("<init>", instructions -> {
            instructions.add((AbstractInsnNode)new InsnNode(89));
            instructions.add((AbstractInsnNode)Utils.generateMethodCall(instr_newInstance));
        }));
    }

    private SensorGroup<InstructionSensor> generateHttpClientSensors(ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> client = Class.forName(HTTP_CLIENT, false, classLoader);
        return new SensorGroupImpl<InstructionSensor>("HttpClientSensor", client, new InstructionSensorImpl((owner, methodName, desc) -> methodName.equals("execute"), (instructions, methodInsnNode) -> {
            StringBuilder sb = new StringBuilder(methodInsnNode.desc);
            sb.insert(1, "Lorg/apache/http/client/HttpClient;");
            instructions.set((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new MethodInsnNode(184, Constants.APACHE_CALLBACK_DYNATRACE.replace('.', '/'), "execute", sb.toString(), false));
        }));
    }
}

