/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Constants;
import com.dynatrace.android.instrumentation.util.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;

public class HybridAppTransformerFactory
implements TransformerFactory {
    private static final String COOKIE_MANAGER = "android.webkit.CookieManager";
    private static final String VALUE_CALLBACK = "android.webkit.ValueCallback";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
        instructionSensors.add(this.generateCookieManagerSensors(classLoader));
        return new DefaultSubTransformer("HybridAppTransformer", instructionSensors, new ArrayList<SensorGroup<MethodSensor>>(), classLoader, warningsAsErrors);
    }

    private SensorGroup<InstructionSensor> generateCookieManagerSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> valueCallback = Class.forName(VALUE_CALLBACK, false, classLoader);
        Class<?> cookieManager = Class.forName(COOKIE_MANAGER, false, classLoader);
        Method removeAllCookie = cookieManager.getDeclaredMethod("removeAllCookie", new Class[0]);
        Method removeAllCookies = cookieManager.getDeclaredMethod("removeAllCookies", valueCallback);
        Method removeSessionCookie = cookieManager.getDeclaredMethod("removeSessionCookie", new Class[0]);
        Method removeSessionCookies = cookieManager.getDeclaredMethod("removeSessionCookies", valueCallback);
        Class<?> callback = Class.forName(Constants.CALLBACK_DYNATRACE, false, classLoader);
        Method restoreCookies = callback.getDeclaredMethod("restoreCookies", new Class[0]);
        TransformerUtils.InstructionFactory factory = instructions -> instructions.add((AbstractInsnNode)Utils.generateMethodCall(restoreCookies));
        return new SensorGroupImpl<InstructionSensor>("CookieManagerSensor", cookieManager, new InsertInstructionSensor(removeAllCookie, factory), new InsertInstructionSensor(removeAllCookies, factory), new InsertInstructionSensor(removeSessionCookie, factory), new InsertInstructionSensor(removeSessionCookies, factory));
    }
}

