/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AGPVersion {
    V3_1(3, 1),
    V3_2(3, 2),
    V3_3(3, 3),
    V3_4(3, 4),
    V3_5(3, 5),
    V3_6(3, 6),
    VUNKNOWN(99, 99);

    private static final Logger logger;
    private final int major;
    private final int minor;

    private AGPVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public static AGPVersion determineAGPVersion(String rawAGPVersion) {
        AGPVersion firstValidVersion = V3_1;
        Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\..*");
        Matcher versionMatcher = pattern.matcher(rawAGPVersion);
        versionMatcher.find();
        if (versionMatcher.matches()) {
            int major = Integer.parseInt(versionMatcher.group(1));
            int minor = Integer.parseInt(versionMatcher.group(2));
            if (major < firstValidVersion.major || major == firstValidVersion.major && minor < firstValidVersion.minor) {
                throw new RuntimeException(String.format("Your version of the Android Gradle Plugin is not supported. Make sure to use version %d.%d or above", firstValidVersion.major, firstValidVersion.minor));
            }
            for (AGPVersion version : AGPVersion.values()) {
                if (version.major != major || version.minor != minor) continue;
                return version;
            }
        }
        logger.warn("Unknown Android Gradle Plugin version \"" + rawAGPVersion + "\" detected");
        return VUNKNOWN;
    }

    public boolean isEither(AGPVersion ... versions) {
        for (AGPVersion version : versions) {
            if (version != this) continue;
            return true;
        }
        return false;
    }

    static {
        logger = LoggerFactory.getLogger((String)"AGPVersion");
    }
}

