/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.dynatrace.android.instrumentation.IncrementalStateVerifier;
import com.dynatrace.android.instrumentation.InvalidIncrementalStateException;
import com.dynatrace.tools.android.IncrementalStateTracker;
import com.dynatrace.tools.android.IncrementalStateUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalStateTrackerGroup {
    private static final Logger logger = LoggerFactory.getLogger((String)"IncrementalStateTrackerGroup");
    private Map<String, IncrementalStateTracker> incrementalState;
    private boolean modifiedIncrementalState;
    private File fileSerialization;

    IncrementalStateTrackerGroup(Map<String, IncrementalStateTracker> state, boolean modifiedIncrementalState, File fileSerialization) {
        this.incrementalState = state;
        this.modifiedIncrementalState = modifiedIncrementalState;
        this.fileSerialization = fileSerialization;
    }

    public static IncrementalStateTrackerGroup create(String fileName, boolean isIncremental) throws InvalidIncrementalStateException {
        if (isIncremental) {
            try {
                return IncrementalStateTrackerGroup.createFromIncrementalState(fileName);
            }
            catch (Exception e) {
                logger.debug("invalid incremental state file", (Throwable)e);
                throw new InvalidIncrementalStateException();
            }
        }
        return IncrementalStateTrackerGroup.createFromNonIncrementalState(fileName);
    }

    private static IncrementalStateTrackerGroup createFromNonIncrementalState(String fileName) {
        File fileSerialization = new File(fileName);
        if (fileSerialization.exists()) {
            fileSerialization.delete();
        }
        return new IncrementalStateTrackerGroup(new HashMap<String, IncrementalStateTracker>(), true, fileSerialization);
    }

    private static IncrementalStateTrackerGroup createFromIncrementalState(String fileName) throws IOException {
        File fileSerialization = new File(fileName);
        Map state = (Map)IncrementalStateUtil.readIncrementalState(fileSerialization);
        logger.debug("state: " + state);
        return new IncrementalStateTrackerGroup(state, false, fileSerialization);
    }

    public void store() throws IOException {
        if (this.modifiedIncrementalState) {
            IncrementalStateUtil.storeIncrementalState(this.fileSerialization, this.incrementalState);
            logger.debug("state: " + this.incrementalState);
        }
    }

    public boolean removeClass(String groupName, String className) {
        IncrementalStateTracker oldValues = this.incrementalState.get(groupName);
        if (oldValues != null && oldValues.removeClass(className)) {
            this.modifiedIncrementalState = true;
            return true;
        }
        return false;
    }

    public boolean removeGroup(String groupName) {
        IncrementalStateTracker oldValues = this.incrementalState.remove(groupName);
        if (oldValues == null) {
            return false;
        }
        logger.debug("Remove incremental state for group" + groupName);
        this.modifiedIncrementalState = true;
        return true;
    }

    public IncrementalStateVerifier getVerifier(String groupName, boolean verify) throws InvalidIncrementalStateException {
        IncrementalStateTracker tracker = this.incrementalState.get(groupName);
        if (verify) {
            if (tracker == null) {
                throw new InvalidIncrementalStateException();
            }
            return tracker::verify;
        }
        if (tracker == null) {
            tracker = new IncrementalStateTracker();
            this.incrementalState.put(groupName, tracker);
        }
        this.modifiedIncrementalState = true;
        return tracker::trackNewClass;
    }

    public IncrementalStateVerifier getJarVerifier(String groupName, boolean verify) throws InvalidIncrementalStateException {
        if (!verify) {
            return this.getVerifier(groupName, false);
        }
        IncrementalStateTracker newTracker = new IncrementalStateTracker();
        IncrementalStateTracker oldTracker = this.incrementalState.put(groupName, newTracker);
        if (oldTracker == null) {
            throw new InvalidIncrementalStateException();
        }
        this.modifiedIncrementalState = true;
        IncrementalStateVerifier verifier = oldTracker::verifyJarChanged;
        return verifier.andThen(newTracker::trackNewClass);
    }
}

