/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.classpath;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.dynatrace.tools.android.Version;
import com.dynatrace.tools.android.classpath.ClassPathAnalyzer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassPathManager {
    private List<URI> systemClassPath;

    public ClassPathManager(List<File> bootClasspath, Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs) {
        this.systemClassPath = Stream.of(bootClasspath.stream(), ClassPathManager.convertToFileStream(inputs), ClassPathManager.convertToFileStream(referencedInputs)).flatMap(Function.identity()).map(File::toURI).collect(Collectors.toList());
    }

    private static Stream<File> convertToFileStream(Collection<TransformInput> input) {
        return input.stream().flatMap(transformInput -> Stream.of(transformInput.getDirectoryInputs(), transformInput.getJarInputs())).flatMap(Collection::stream).map(QualifiedContent::getFile);
    }

    private static URL convertUriToUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("invalid uri: " + uri, e);
        }
    }

    public URL[] buildClassPath() {
        return (URL[])this.systemClassPath.stream().map(ClassPathManager::convertUriToUrl).toArray(URL[]::new);
    }

    public void verifyClassPath(URLClassLoader classLoader) throws TransformException {
        ClassPathAnalyzer extractor = new ClassPathAnalyzer(classLoader);
        if (extractor.containsCompuwareAgent()) {
            throw new TransformException("Invalid agent version detected");
        }
        String agentVersion = extractor.determineAgentVersion();
        if (agentVersion == null) {
            throw new TransformException("OneAgent SDK missing");
        }
        if (!Version.getFullVersion().equals(agentVersion)) {
            throw new TransformException("OneAgent SDK version " + agentVersion + " does not match Dynatrace Android Gradle plugin version " + Version.getFullVersion());
        }
        if (!extractor.containsInstrumentationLibraries()) {
            throw new TransformException("Instrumentation libraries are missing");
        }
    }
}

