/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.dsl;

import com.dynatrace.tools.android.dsl.DebugOptions;
import com.dynatrace.tools.android.dsl.ExcludeOptions;
import com.dynatrace.tools.android.dsl.HybridOptions;
import com.dynatrace.tools.android.dsl.LifecycleOptions;
import com.dynatrace.tools.android.dsl.StartOptions;
import com.dynatrace.tools.android.dsl.UserActionOptions;
import com.dynatrace.tools.android.dsl.WebRequestOptions;
import java.io.Serializable;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.internal.reflect.Instantiator;

public class VariantConfiguration
implements Serializable {
    private String name;
    private boolean enabled;
    private String variantFilter;
    private StartOptions autoStart;
    private UserActionOptions userActions;
    private WebRequestOptions webRequests;
    private HybridOptions hybridWebView;
    private boolean crashReporting;
    private LifecycleOptions lifecycle;
    private boolean locationMonitoring;
    private boolean userOptIn;
    private ExcludeOptions exclude;
    private DebugOptions debug;

    public VariantConfiguration(String name, Instantiator instantiator) {
        this(name, true, null, (StartOptions)instantiator.newInstance(StartOptions.class, new Object[0]), (UserActionOptions)instantiator.newInstance(UserActionOptions.class, new Object[]{instantiator}), (WebRequestOptions)instantiator.newInstance(WebRequestOptions.class, new Object[]{instantiator}), (HybridOptions)instantiator.newInstance(HybridOptions.class, new Object[0]), true, (LifecycleOptions)instantiator.newInstance(LifecycleOptions.class, new Object[]{instantiator}), false, false, (ExcludeOptions)instantiator.newInstance(ExcludeOptions.class, new Object[]{instantiator}), (DebugOptions)instantiator.newInstance(DebugOptions.class, new Object[0]));
    }

    VariantConfiguration(VariantConfiguration source) {
        this(source.name, source.enabled, source.variantFilter, new StartOptions(source.autoStart), new UserActionOptions(source.userActions), new WebRequestOptions(source.webRequests), new HybridOptions(source.hybridWebView), source.crashReporting, new LifecycleOptions(source.lifecycle), source.locationMonitoring, source.userOptIn, new ExcludeOptions(source.exclude), new DebugOptions(source.debug));
    }

    VariantConfiguration(String name, boolean enabled, String variantFilter, StartOptions autoStart, UserActionOptions userActions, WebRequestOptions webRequests, HybridOptions hybridWebView, boolean crashReporting, LifecycleOptions lifecycle, boolean locationMonitoring, boolean userOptIn, ExcludeOptions exclude, DebugOptions debug) {
        this.name = name;
        this.enabled = enabled;
        this.variantFilter = variantFilter;
        this.autoStart = autoStart;
        this.userActions = userActions;
        this.webRequests = webRequests;
        this.hybridWebView = hybridWebView;
        this.crashReporting = crashReporting;
        this.lifecycle = lifecycle;
        this.locationMonitoring = locationMonitoring;
        this.userOptIn = userOptIn;
        this.exclude = exclude;
        this.debug = debug;
    }

    public String getName() {
        return this.name;
    }

    public void enabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void variantFilter(String variantFilter) {
        this.variantFilter = variantFilter;
    }

    public void autoStart(Action<? super StartOptions> action) {
        action.execute((Object)this.autoStart);
    }

    public void userActions(Action<? super UserActionOptions> action) {
        action.execute((Object)this.userActions);
    }

    public void webRequests(Action<? super WebRequestOptions> action) {
        action.execute((Object)this.webRequests);
    }

    public void hybridWebView(Action<? super HybridOptions> action) {
        action.execute((Object)this.hybridWebView);
    }

    public void crashReporting(boolean crashReporting) {
        this.crashReporting = crashReporting;
    }

    public void lifecycle(Action<? super LifecycleOptions> action) {
        action.execute((Object)this.lifecycle);
    }

    public void locationMonitoring(boolean locationMonitoring) {
        this.locationMonitoring = locationMonitoring;
    }

    public void userOptIn(boolean userOptIn) {
        this.userOptIn = userOptIn;
    }

    public void exclude(Action<? super ExcludeOptions> action) {
        action.execute((Object)this.exclude);
    }

    public void debug(Action<? super DebugOptions> action) {
        action.execute((Object)this.debug);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getVariantFilter() {
        return this.variantFilter;
    }

    public StartOptions getAutoStart() {
        return this.autoStart;
    }

    public UserActionOptions getUserActions() {
        return this.userActions;
    }

    public WebRequestOptions getWebRequests() {
        return this.webRequests;
    }

    public HybridOptions getHybridWebView() {
        return this.hybridWebView;
    }

    public boolean isCrashReporting() {
        return this.crashReporting;
    }

    public LifecycleOptions getLifecycle() {
        return this.lifecycle;
    }

    public boolean isLocationMonitoring() {
        return this.locationMonitoring;
    }

    public boolean isUserOptIn() {
        return this.userOptIn;
    }

    public ExcludeOptions getExclude() {
        return this.exclude;
    }

    public DebugOptions getDebug() {
        return this.debug;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VariantConfiguration)) {
            return false;
        }
        VariantConfiguration that = (VariantConfiguration)other;
        return Objects.equals(this.name, that.name) && this.enabled == that.enabled && Objects.equals(this.variantFilter, that.variantFilter) && Objects.equals(this.autoStart, that.autoStart) && Objects.equals(this.userActions, that.userActions) && Objects.equals(this.webRequests, that.webRequests) && Objects.equals(this.hybridWebView, that.hybridWebView) && this.crashReporting == that.crashReporting && Objects.equals(this.lifecycle, that.lifecycle) && this.locationMonitoring == that.locationMonitoring && this.userOptIn == that.userOptIn && Objects.equals(this.exclude, that.exclude) && Objects.equals(this.debug, that.debug);
    }

    public String toString() {
        return "VariantConfiguration{name='" + this.name + '\'' + ", enabled=" + this.enabled + ", variantFilter='" + this.variantFilter + '\'' + ", autoStart=" + this.autoStart + ", userActions=" + this.userActions + ", webRequests=" + this.webRequests + ", hybridWebView=" + this.hybridWebView + ", crashReporting=" + this.crashReporting + ", lifecycle=" + this.lifecycle + ", locationMonitoring=" + this.locationMonitoring + ", userOptIn=" + this.userOptIn + ", exclude=" + this.exclude + ", debug=" + this.debug + '}';
    }
}

