/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.manifest;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gradle.api.GradleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AndroidManifestProcessor {
    private static final Logger logger = LoggerFactory.getLogger((String)"AndroidManifestProcessor");
    private static final String DT_APPLICATION_CLASS = "com.dynatrace.android.app.Application";
    private static final String KEY_ANDROID_APPLICATION = "android:name";
    private boolean failsOnWarning;

    public AndroidManifestProcessor(boolean failsOnWarning) {
        this.failsOnWarning = failsOnWarning;
    }

    public void instrumentManifest(File manifest) {
        Document doc;
        if (manifest == null) {
            this.logWarning("The AndroidManifest file is null", null);
            return;
        }
        logger.debug("Verifying Android manifest at " + manifest.getAbsolutePath());
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(manifest);
        }
        catch (Exception e) {
            this.logWarning("Failed to verify the AndroidManifest file at " + manifest.getAbsolutePath(), e);
            return;
        }
        Node application = doc.getElementsByTagName("application").item(0);
        NamedNodeMap attributes = application.getAttributes();
        Node nameAttribute = attributes.getNamedItem(KEY_ANDROID_APPLICATION);
        if (nameAttribute == null) {
            logger.info("Inserting the Dynatrace Application class into the Android manifest");
            ((Element)application).setAttribute(KEY_ANDROID_APPLICATION, DT_APPLICATION_CLASS);
            try {
                Transformer xmlTransformer = TransformerFactory.newInstance().newTransformer();
                xmlTransformer.setOutputProperty("indent", "yes");
                xmlTransformer.setOutputProperty("method", "xml");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(manifest);
                xmlTransformer.transform(source, result);
            }
            catch (TransformerException e) {
                this.logWarning("Failed to write modified manifest file at " + manifest.getAbsolutePath(), e);
            }
        }
    }

    private void logWarning(String message, Exception e) {
        logger.warn(message, (Throwable)e);
        if (this.failsOnWarning) {
            throw new GradleException(message, (Throwable)e);
        }
    }
}

