/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.transformation;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.dynatrace.android.instrumentation.InvalidIncrementalStateException;
import com.dynatrace.tools.android.transformation.BuildHandler;
import com.dynatrace.tools.android.transformation.FileTransformer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildArtifactTransformer {
    private static final Logger logger = LoggerFactory.getLogger((String)"BuildArtifactTransformer");
    private BuildHandler buildHandler;
    private boolean isIncremental;

    public BuildArtifactTransformer(BuildHandler buildHandler, boolean isIncremental) {
        this.buildHandler = buildHandler;
        this.isIncremental = isIncremental;
    }

    public static String convertFileNameToClassName(String fileName) {
        int startIndex = fileName.startsWith("/") || fileName.startsWith("\\") ? 1 : 0;
        return fileName.substring(startIndex, fileName.length() - 6).replace('\\', '.').replace('/', '.');
    }

    public void handleTransformation(TransformInvocation transformInvocation) throws IOException, TransformException, InvalidIncrementalStateException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        for (TransformInput input : transformInvocation.getInputs()) {
            for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                this.handleDirectoryInput(dirInput, outputProvider);
            }
            for (JarInput jarInput : input.getJarInputs()) {
                this.handleJarInput(jarInput, outputProvider);
            }
        }
    }

    private void handleDirectoryInput(DirectoryInput dirInput, TransformOutputProvider outputProvider) throws IOException, TransformException, InvalidIncrementalStateException {
        Set<Path> removedFiles;
        String name = dirInput.getName();
        Path output = outputProvider.getContentLocation(name, dirInput.getContentTypes(), dirInput.getScopes(), Format.DIRECTORY).toPath();
        Path rootFile = dirInput.getFile().toPath();
        Map<Status, Set<Path>> changedFiles = this.handleDirectories(dirInput);
        logger.debug("Changed files: " + changedFiles);
        Set<Path> skippedFiles = changedFiles.get(Status.NOTCHANGED);
        if (skippedFiles != null) {
            for (Path file : skippedFiles) {
                logger.debug("Skip file/directory " + file);
            }
        }
        if ((removedFiles = changedFiles.get(Status.REMOVED)) != null) {
            Consumer<String> listener = this.buildHandler.getFileRemovedListener(name);
            List sortedList = removedFiles.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            for (Path file : sortedList) {
                Path relativeFile = rootFile.relativize(file);
                Path outputFile = output.resolve(relativeFile);
                if (Files.isDirectory(outputFile, new LinkOption[0])) {
                    logger.debug("Remove directory " + outputFile);
                    Files.deleteIfExists(outputFile);
                    continue;
                }
                logger.debug("Remove file " + outputFile);
                Files.deleteIfExists(outputFile);
                if (listener == null) continue;
                listener.accept(BuildArtifactTransformer.convertFileNameToClassName(relativeFile.toString()));
            }
        }
        this.handleFileTransformation(changedFiles.get(Status.CHANGED), rootFile, output, this.buildHandler.getFileTransformer(name, Status.CHANGED), Status.CHANGED);
        this.handleFileTransformation(changedFiles.get(Status.ADDED), rootFile, output, this.buildHandler.getFileTransformer(name, Status.ADDED), Status.ADDED);
    }

    private Map<Status, Set<Path>> handleDirectories(DirectoryInput dirInput) throws IOException {
        if (this.isIncremental) {
            return dirInput.getChangedFiles().entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(fileStatusEntry -> ((File)fileStatusEntry.getKey()).toPath(), Collectors.toSet())));
        }
        Set classFiles = Files.walk(dirInput.getFile().toPath(), new FileVisitOption[0]).filter(file -> !Files.isDirectory(file, new LinkOption[0])).collect(Collectors.toSet());
        HashMap<Status, Set<Path>> changes = new HashMap<Status, Set<Path>>();
        changes.put(Status.ADDED, classFiles);
        return changes;
    }

    private void handleJarInput(JarInput jarInput, TransformOutputProvider outputProvider) throws IOException, TransformException, InvalidIncrementalStateException {
        Path jarFile = jarInput.getFile().toPath();
        String name = jarInput.getName();
        Path output = outputProvider.getContentLocation(name, jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR).toPath();
        Status status = jarInput.getStatus();
        if (!this.isIncremental && status != Status.REMOVED) {
            status = Status.ADDED;
        }
        switch (status) {
            case NOTCHANGED: {
                logger.debug("Skip jar " + jarFile);
                break;
            }
            case REMOVED: {
                logger.debug("Remove jar " + output);
                Files.deleteIfExists(output);
                Consumer<Path> listener = this.buildHandler.getJarRemovedListener(name);
                if (listener == null) break;
                listener.accept(jarFile);
                break;
            }
            case ADDED: 
            case CHANGED: {
                logger.debug("Store jar " + jarFile + " to " + output);
                if (status == Status.ADDED) {
                    Files.createDirectories(output.getParent(), new FileAttribute[0]);
                }
                this.buildHandler.getJarTransformer(name, status).transformJar(jarFile, output);
            }
        }
    }

    private void handleFileTransformation(Set<Path> files, Path source, Path dest, FileTransformer handler, Status status) throws TransformException, InvalidIncrementalStateException, IOException {
        if (files == null) {
            return;
        }
        for (Path file : files) {
            if (Files.isDirectory(file, new LinkOption[0])) {
                logger.debug("Ignore directory " + file + " with status = " + status);
                continue;
            }
            if (!file.toString().endsWith(".class")) {
                logger.debug("Ignore non class file " + file);
                continue;
            }
            Path relativeFile = source.relativize(file);
            Path outputFile = dest.resolve(relativeFile);
            logger.debug("Store file " + file + " to " + outputFile);
            if (status == Status.ADDED) {
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            }
            handler.transformFile(file, outputFile, BuildArtifactTransformer.convertFileNameToClassName(relativeFile.toString()));
        }
    }
}

