/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation;

import com.dynatrace.android.instrumentation.IncrementalStateVerifier;
import com.dynatrace.android.instrumentation.InvalidIncrementalStateException;
import com.dynatrace.android.instrumentation.filter.ClassLevelFilter;
import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.filter.MethodLevelFilter;
import com.dynatrace.android.instrumentation.filter.PackageExclusionFilter;
import com.dynatrace.android.instrumentation.shared.ResolvingClassWriter;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Instrumentor {
    private static final Logger logger = LoggerFactory.getLogger((String)"Instrumentor");
    private ClassLoader classLoader;
    private List<SubTransformer> transformers;
    private boolean performAsmVerify = true;
    private Consumer<byte[]> verificationConsumer = null;
    private ExclusionManager exclusionManager = null;
    private boolean warningsAsErrors = false;

    private Instrumentor(ClassLoader classLoader, List<SubTransformer> transformers) {
        this.classLoader = classLoader;
        this.transformers = transformers;
    }

    private boolean analyze(Class<?> clazz, IncrementalStateVerifier incrementalStateVerifier) throws InvalidIncrementalStateException {
        boolean instrument = true;
        ArrayList<String> sensorKeys = new ArrayList<String>();
        for (SubTransformer transformer : this.transformers) {
            instrument &= transformer.generateIncrementalStateKeys(sensorKeys, clazz);
        }
        if (!incrementalStateVerifier.verify(clazz.getName(), sensorKeys)) {
            throw new InvalidIncrementalStateException();
        }
        if (!instrument) {
            logger.debug("Ignore class {}", (Object)clazz.getName());
            return false;
        }
        return true;
    }

    public byte[] instrument(String className, byte[] bytes, IncrementalStateVerifier incrementalStateVerifier) throws ClassNotFoundException, InvalidIncrementalStateException {
        Class<?> clazz;
        if (this.exclusionManager.filterClass(className)) {
            return bytes;
        }
        try {
            clazz = Class.forName(className, false, this.classLoader);
        }
        catch (Throwable t) {
            if (this.warningsAsErrors || t instanceof UnsupportedClassVersionError) {
                throw t;
            }
            logger.info("skip non loadable class {}, {}", (Object)className, (Object)t.toString());
            if (!incrementalStateVerifier.verify(className, new ArrayList<String>())) {
                throw new InvalidIncrementalStateException();
            }
            return bytes;
        }
        if (!this.analyze(clazz, incrementalStateVerifier)) {
            return bytes;
        }
        ClassNode cn = new ClassNode();
        try {
            ClassReader cr = new ClassReader(bytes);
            cr.accept((ClassVisitor)cn, 0);
        }
        catch (Throwable t) {
            if (this.warningsAsErrors) {
                throw t;
            }
            logger.info("skip non readable class {}, {}", (Object)className, (Object)t.toString());
            return bytes;
        }
        if (!this.transform0(this.classLoader, cn, clazz)) {
            logger.debug("No modifications for {}", (Object)clazz.getName());
            return bytes;
        }
        ResolvingClassWriter writer = new ResolvingClassWriter(1 | (cn.version >= 51 ? 2 : 0), this.classLoader);
        cn.accept((ClassVisitor)writer);
        byte[] modBytes = writer.toByteArray();
        if (this.performAsmVerify) {
            try {
                Utils.verify(modBytes, this.classLoader);
            }
            catch (Exception e) {
                if (this.verificationConsumer != null) {
                    this.verificationConsumer.accept(modBytes);
                }
                throw e;
            }
        }
        return modBytes;
    }

    private boolean transform0(ClassLoader loader, ClassNode classNode, Class<?> clazz) {
        boolean transformed = false;
        for (SubTransformer transformer : this.transformers) {
            transformed |= transformer.transformClass(clazz, classNode, this.exclusionManager);
        }
        ArrayList methods = new ArrayList(classNode.methods);
        for (MethodNode method : methods) {
            if (method.instructions == null || method.instructions.size() == 0 || this.exclusionManager.filterMethod(classNode.name.replaceAll("/", "."), method.name, method.desc)) continue;
            if (method.localVariables == null) {
                method.localVariables = new ArrayList();
            }
            for (SubTransformer transformer : this.transformers) {
                transformed |= transformer.transformMethod(clazz, classNode, method, this.exclusionManager);
            }
        }
        return transformed;
    }

    public static class Builder {
        private ClassLoader classLoader = null;
        private List<TransformerFactory> factories = new ArrayList<TransformerFactory>();
        private boolean performAsmVerify = true;
        private Consumer<byte[]> verificationConsumer = null;
        private boolean warningsAsErrors = false;
        private ExclusionManager exclusionManager = new ExclusionManager(new ArrayList<ClassLevelFilter>(), new ArrayList<MethodLevelFilter>());

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder setExclusionManager(ExclusionManager exclusionManager) {
            this.exclusionManager = exclusionManager;
            return this;
        }

        public Builder setTransformerFactories(List<TransformerFactory> factories) {
            this.factories = factories;
            return this;
        }

        public Builder addTransformerFactory(TransformerFactory factory) {
            this.factories.add(factory);
            return this;
        }

        public Builder addTransformerFactories(TransformerFactory ... factories) {
            for (TransformerFactory factory : factories) {
                this.addTransformerFactory(factory);
            }
            return this;
        }

        public Builder shouldPerformAsmVerify(boolean performAsmVerify) {
            this.performAsmVerify = performAsmVerify;
            return this;
        }

        public Builder setVerificationConsumer(Consumer<byte[]> verificationConsumer) {
            this.verificationConsumer = verificationConsumer;
            return this;
        }

        public Builder setWarningsAsErrors(boolean warningsAsErrors) {
            this.warningsAsErrors = warningsAsErrors;
            return this;
        }

        public Instrumentor build() throws Exception {
            if (this.classLoader == null) {
                throw new IllegalArgumentException("Missing component classLoader");
            }
            this.exclusionManager.addClassFileFilter(Arrays.asList(new PackageExclusionFilter("com.dynatrace.android"), className -> className.endsWith("package-info"), className -> className.endsWith("module-info")));
            ArrayList<SubTransformer> transformers = new ArrayList<SubTransformer>();
            for (TransformerFactory transformerFactory : this.factories) {
                SubTransformer transformer = transformerFactory.generateTransformer(this.classLoader, this.warningsAsErrors);
                if (transformer == null) continue;
                transformers.add(transformer);
                this.exclusionManager.addMandatoryClasses(transformerFactory.mandatoryClasses());
                this.exclusionManager.addClassFileFilter(transformerFactory.excludeClassFiles());
            }
            HashSet<String> keys = new HashSet<String>();
            for (SubTransformer transformer : transformers) {
                List<String> newKeys = transformer.getAllKeys();
                if (newKeys == null || newKeys.isEmpty()) {
                    throw new IllegalArgumentException("transformer has to specify a key");
                }
                for (String key : newKeys) {
                    if (keys.contains(key)) {
                        throw new IllegalArgumentException("duplicate sensor key: " + key);
                    }
                    keys.add(key);
                }
            }
            Instrumentor instrumentor = new Instrumentor(this.classLoader, transformers);
            instrumentor.performAsmVerify = this.performAsmVerify;
            instrumentor.verificationConsumer = this.verificationConsumer;
            instrumentor.exclusionManager = this.exclusionManager;
            instrumentor.warningsAsErrors = this.warningsAsErrors;
            return instrumentor;
        }
    }
}

