/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.instrumentor;

import com.dynatrace.android.instrumentation.UnknownLambdaTagException;
import com.dynatrace.android.instrumentation.UnsupportedByteCodeException;
import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.util.LambdaConverterData;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaInstrumentor {
    private static final String CLASS_LAMBDA_METAFACTORY = "java/lang/invoke/LambdaMetafactory";
    private static final String METHOD_LAMBDA_METAFACTORY = "metafactory";
    private static final String DESC_LAMBDA_METAFACTORY = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
    private static final Logger logger = LoggerFactory.getLogger((String)"LambdaInstrumentor");
    private ClassLoader classLoader;
    private List<SensorGroup<InstructionSensor>> instructionTransformers;
    private List<SensorGroup<MethodSensor>> methodSensors;
    private boolean warningsAsErrors;

    public LambdaInstrumentor(ClassLoader classLoader, List<SensorGroup<InstructionSensor>> instructionTransformers, List<SensorGroup<MethodSensor>> methodSensors, boolean warningsAsErrors) {
        this.instructionTransformers = instructionTransformers;
        this.methodSensors = methodSensors;
        this.classLoader = classLoader;
        this.warningsAsErrors = warningsAsErrors;
    }

    public boolean transformMethod(ClassNode classNode, MethodNode method, ExclusionManager exclusionManager) {
        ArrayList<InvokeDynamicInsnNode> lambdaInstructions = new ArrayList<InvokeDynamicInsnNode>();
        for (AbstractInsnNode instruction : method.instructions) {
            if (!(instruction instanceof InvokeDynamicInsnNode)) continue;
            lambdaInstructions.add((InvokeDynamicInsnNode)instruction);
        }
        boolean modified = false;
        int count = 0;
        for (InvokeDynamicInsnNode node : lambdaInstructions) {
            if (node.bsm.getOwner().equals(CLASS_LAMBDA_METAFACTORY) && node.bsm.getName().equals(METHOD_LAMBDA_METAFACTORY) && node.bsm.getDesc().equals(DESC_LAMBDA_METAFACTORY) && node.bsmArgs.length == 3) {
                String methodName = method.name.equals("<init>") ? "new" : (method.name.equals("<clinit>") ? "static" : method.name);
                String newMethodName = "instrumented$" + count + "$" + methodName;
                ++count;
                modified |= this.instrumentLambda(node, newMethodName, classNode, exclusionManager);
                continue;
            }
            String msg = "found unknown invokedynamic instruction: owner=" + node.bsm.getOwner() + " name=" + node.bsm.getName() + " desc=" + node.bsm.getDesc();
            if (this.warningsAsErrors) {
                throw new UnsupportedByteCodeException(msg);
            }
            logger.info(msg);
        }
        return modified;
    }

    private boolean instrumentLambda(InvokeDynamicInsnNode node, String newMethodName, ClassNode classNode, ExclusionManager exclusionManager) {
        LambdaConverterData trampolineData;
        Type instantiatedMethodType;
        Handle methodHandle;
        Type samMethodType;
        try {
            samMethodType = (Type)node.bsmArgs[0];
            methodHandle = (Handle)node.bsmArgs[1];
            instantiatedMethodType = (Type)node.bsmArgs[2];
        }
        catch (ClassCastException e) {
            String msg = "unknown/invalid lambda bootstrap method";
            if (this.warningsAsErrors) {
                throw new UnsupportedByteCodeException(msg, e);
            }
            logger.info(msg, (Throwable)e);
            return false;
        }
        Optional<InstructionSensor> instrTransformer = this.findInstructionTransformer(methodHandle, exclusionManager);
        List<MethodSensor> methodTransformers = this.findMethodTransformers(node, samMethodType);
        if (!instrTransformer.isPresent() && methodTransformers.isEmpty()) {
            return false;
        }
        try {
            trampolineData = this.addTrampolineMethod(classNode, node, newMethodName, methodHandle, instantiatedMethodType);
        }
        catch (UnknownLambdaTagException e) {
            String msg = "unknown invokedynamic node";
            if (this.warningsAsErrors) {
                throw new UnsupportedByteCodeException(msg, e);
            }
            logger.info(msg, (Throwable)e);
            return false;
        }
        instrTransformer.ifPresent(instructionSensor -> instructionSensor.transform(trampolineData.methodNode.instructions, trampolineData.methodInsnNode));
        MethodNode trampolineNode = trampolineData.methodNode;
        int index = (Type.getType((String)trampolineNode.desc).getArgumentsAndReturnSizes() >> 2) - (instantiatedMethodType.getArgumentsAndReturnSizes() >> 2);
        for (MethodSensor methodSensor : methodTransformers) {
            methodSensor.transformMethod(trampolineNode, index);
        }
        return true;
    }

    private Optional<InstructionSensor> findInstructionTransformer(Handle methodHandle, ExclusionManager exclusionManager) {
        Class<?> clazzOwner;
        String className = Type.getObjectType((String)methodHandle.getOwner()).getClassName();
        if (exclusionManager.filterInvokeInstruction(className, methodHandle.getName(), methodHandle.getDesc())) {
            logger.debug("exclude method handle {}.{}{}", new Object[]{className, methodHandle.getName(), methodHandle.getDesc()});
            return Optional.empty();
        }
        try {
            clazzOwner = Class.forName(className, false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            logger.info("skip instruction with unknown method call {}.{}{}, {}", new Object[]{className, methodHandle.getName(), methodHandle.getDesc(), e.toString()});
            return Optional.empty();
        }
        catch (Throwable t) {
            if (this.warningsAsErrors || t instanceof UnsupportedClassVersionError) {
                throw t;
            }
            logger.info("skip instruction with unknown method call {}.{}{}, {}", new Object[]{className, methodHandle.getName(), methodHandle.getDesc(), t.toString()});
            return Optional.empty();
        }
        return this.instructionTransformers.stream().filter(sensorGroup -> sensorGroup.matchClass(clazzOwner)).flatMap(sensorGroup -> sensorGroup.getSensors().stream()).filter(sensor -> sensor.matchInstruction(clazzOwner, methodHandle.getName(), methodHandle.getDesc())).findAny();
    }

    private List<MethodSensor> findMethodTransformers(InvokeDynamicInsnNode node, Type type) {
        Class<?> clazzLambda;
        Type methodType = Type.getType((String)node.desc);
        String className = methodType.getReturnType().getClassName();
        try {
            clazzLambda = Class.forName(className, false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            logger.info("skip unknown NameAndType: type={} name={}, {}", new Object[]{node.desc, node.name, e.toString()});
            return new ArrayList<MethodSensor>();
        }
        catch (Throwable t) {
            if (this.warningsAsErrors || t instanceof UnsupportedClassVersionError) {
                throw t;
            }
            logger.info("skip unknown NameAndType: type={} name={}, {}", new Object[]{node.desc, node.name, t.toString()});
            return new ArrayList<MethodSensor>();
        }
        return this.methodSensors.stream().filter(sensorGroup -> sensorGroup.matchClass(clazzLambda)).flatMap(sensorGroup -> sensorGroup.getSensors().stream()).filter(sensor -> sensor.matchMethod(clazzLambda, node.name, type.getDescriptor(), true)).collect(Collectors.toList());
    }

    private LambdaConverterData addTrampolineMethod(ClassNode classNode, InvokeDynamicInsnNode node, String newMethodName, Handle methodHandle, Type type) throws UnknownLambdaTagException {
        Type methodType = Type.getType((String)node.desc);
        String lambdaClazz = methodType.getReturnType().getClassName();
        String className = Type.getObjectType((String)methodHandle.getOwner()).getClassName();
        if (logger.isDebugEnabled()) {
            logger.debug("Detected lambda for method {}.{}{} . Instrument bootstrap method with method call {}.{}{}", new Object[]{lambdaClazz, node.name, type.getDescriptor(), className, methodHandle.getName(), methodHandle.getDesc()});
        }
        LambdaConverterData data = Utils.extractLambdaIntoExtraMethod(newMethodName, methodHandle, type, methodType.getArgumentTypes());
        MethodNode trampolineNode = data.methodNode;
        logger.debug("New method {}{} created", (Object)trampolineNode.name, (Object)trampolineNode.desc);
        classNode.methods.add(trampolineNode);
        node.bsmArgs[1] = new Handle(6, classNode.name, newMethodName, trampolineNode.desc, false);
        return data;
    }
}

