/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.android.build.gradle.AppExtension;
import com.dynatrace.tools.android.dsl.DynatraceExtension;
import com.dynatrace.tools.android.dsl.VariantConfiguration;
import com.dynatrace.tools.android.dsl.VariantConfigurationUtil;
import java.util.Optional;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class PrintVariantAffiliationTask
extends DefaultTask {
    @TaskAction
    public void print() {
        DynatraceExtension extension = (DynatraceExtension)this.getProject().getRootProject().getExtensions().findByType(DynatraceExtension.class);
        if (extension == null) {
            throw new GradleException("No Dynatrace configuration defined");
        }
        AppExtension androidExt = (AppExtension)this.getProject().getExtensions().getByType(AppExtension.class);
        if (androidExt == null) {
            throw new GradleException("Could not find Android application extension");
        }
        androidExt.getApplicationVariants().forEach(applicationVariant -> {
            Optional<VariantConfiguration> result = VariantConfigurationUtil.determineVariantConfiguration(extension, applicationVariant.getName());
            if (result.isPresent()) {
                System.out.println("Variant '" + applicationVariant.getName() + "' will use configuration '" + result.get().getName() + "'");
            } else {
                System.out.println("Variant '" + applicationVariant.getName() + "' has no matching configuration");
            }
        });
    }
}

