/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.dsl;

import com.dynatrace.android.instrumentation.filter.ClassExclusionFilter;
import com.dynatrace.android.instrumentation.filter.ClassLevelFilter;
import com.dynatrace.android.instrumentation.filter.CustomClassExclusionFilter;
import com.dynatrace.android.instrumentation.filter.CustomMethodExclusionFilter;
import com.dynatrace.android.instrumentation.filter.MethodExclusionFilter;
import com.dynatrace.android.instrumentation.filter.MethodLevelFilter;
import com.dynatrace.android.instrumentation.filter.PackageExclusionFilter;
import com.dynatrace.tools.android.dsl.ExcludeFilterOptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.internal.reflect.Instantiator;

public class ExcludeOptions
implements Serializable {
    private List<String> packages;
    private List<String> classes;
    private List<String> methods;
    private List<ExcludeFilterOptions> filters;
    private transient Instantiator instantiator = null;

    public ExcludeOptions(Instantiator instantiator) {
        this(new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<ExcludeFilterOptions>());
        this.instantiator = instantiator;
    }

    ExcludeOptions(ExcludeOptions source) {
        this(new ArrayList<String>(source.packages), new ArrayList<String>(source.classes), new ArrayList<String>(source.methods), source.filters.stream().map(ExcludeFilterOptions::new).collect(Collectors.toList()));
    }

    ExcludeOptions(List<String> packages, List<String> classes, List<String> methods, List<ExcludeFilterOptions> filters) {
        this.packages = packages;
        this.classes = classes;
        this.methods = methods;
        this.filters = filters;
    }

    public void packages(String _package) {
        this.packages.add(_package);
    }

    public void packages(String ... packages) {
        this.packages.addAll(Arrays.asList(packages));
    }

    public void classes(String _class) {
        this.classes.add(_class);
    }

    public void classes(String ... classes) {
        this.classes.addAll(Arrays.asList(classes));
    }

    public void methods(String method) {
        this.methods.add(method);
    }

    public void methods(String ... methods) {
        this.methods.addAll(Arrays.asList(methods));
    }

    public void filter(Action<? super ExcludeFilterOptions> action) {
        ExcludeFilterOptions excludeFilterOptions = (ExcludeFilterOptions)this.instantiator.newInstance(ExcludeFilterOptions.class, new Object[0]);
        action.execute((Object)excludeFilterOptions);
        this.filters.add(excludeFilterOptions);
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public List<ExcludeFilterOptions> getFilter() {
        return this.filters;
    }

    List<ClassLevelFilter> getClassLevelFilter() {
        ArrayList<ClassLevelFilter> filters = new ArrayList<ClassLevelFilter>();
        if (this.packages != null) {
            for (String packageFilterStr : this.packages) {
                filters.add(new PackageExclusionFilter(packageFilterStr));
            }
        }
        if (this.classes != null) {
            for (String classFilterStr : this.classes) {
                filters.add(new ClassExclusionFilter(classFilterStr));
            }
        }
        for (ExcludeFilterOptions excludeFilterOptions : this.filters) {
            if (!excludeFilterOptions.isClassLevelFilter()) continue;
            filters.add(new CustomClassExclusionFilter(excludeFilterOptions.getClassName()));
        }
        return filters;
    }

    List<MethodLevelFilter> getMethodLevelFilter() {
        ArrayList<MethodLevelFilter> filters = new ArrayList<MethodLevelFilter>();
        if (this.methods != null) {
            for (String methodFilterStr : this.methods) {
                filters.add(new MethodExclusionFilter(methodFilterStr));
            }
        }
        for (ExcludeFilterOptions excludeFilterOptions : this.filters) {
            if (excludeFilterOptions.isClassLevelFilter()) continue;
            filters.add(new CustomMethodExclusionFilter(excludeFilterOptions.getClassName(), excludeFilterOptions.getMethodName(), excludeFilterOptions.getMethodDescription()));
        }
        return filters;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExcludeOptions)) {
            return false;
        }
        ExcludeOptions that = (ExcludeOptions)other;
        return Objects.equals(this.packages, that.packages) && Objects.equals(this.classes, that.classes) && Objects.equals(this.methods, that.methods) && Objects.equals(this.filters, that.filters);
    }

    public String toString() {
        return "ExcludeOptions{packages=" + this.packages + ", classes=" + this.classes + ", methods=" + this.methods + ", filters=" + this.filters + '}';
    }
}

