/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.method;

import com.dynatrace.android.instrumentation.sensor.method.MandatoryMethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.util.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MandatoryMethodSensorImpl
extends MethodSensorImpl
implements MandatoryMethodSensor {
    private Method method;

    public MandatoryMethodSensorImpl(Method method, MethodTransformation ... transformations) {
        super(method, transformations);
        this.method = method;
        if (method.getDeclaringClass().isInterface()) {
            throw new IllegalArgumentException("interface methods are not supported with this sensor type");
        }
    }

    @Override
    public MethodNode transformForMissingMethod(ClassNode classNode, Class<?> clazz) {
        for (Class<?> curClass = clazz.getSuperclass(); curClass != this.method.getDeclaringClass(); curClass = curClass.getSuperclass()) {
            try {
                Method superMethod = curClass.getDeclaredMethod(this.method.getName(), this.method.getParameterTypes());
                if (!Modifier.isFinal(superMethod.getModifiers())) continue;
                return null;
            }
            catch (NoSuchMethodException superMethod) {
                // empty catch block
            }
        }
        MethodNode methodNode = Utils.generateSyntheticMethod(classNode.superName, this.method, this.method.getName(), true);
        this.transformMethod(methodNode, (methodNode.access & 8) == 0 ? 1 : 0);
        return methodNode;
    }
}

