/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.method.generics;

import com.dynatrace.android.instrumentation.sensor.method.MethodFilter;
import com.dynatrace.android.instrumentation.sensor.method.generics.GenericTypeAnalyzer;
import com.dynatrace.android.instrumentation.sensor.method.generics.ResolvedGenericInfo;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.Type;

public class GenericClassMethodFilter
implements MethodFilter {
    private Method method;
    private GenericTypeAnalyzer analyzer;

    public GenericClassMethodFilter(Method method) {
        this.method = method;
        this.analyzer = new GenericTypeAnalyzer(method.getDeclaringClass());
    }

    @Override
    public boolean matchMethod(Class<?> clazz, String methodName, String methodDesc, boolean isLambda) {
        if (isLambda) {
            return this.match(clazz, methodName, methodDesc, this::matchAllDescriptions);
        }
        return this.match(clazz, methodName, methodDesc, this::matchMainDescription);
    }

    private boolean match(Class<?> clazz, String methodName, String methodDesc, MethodDescriptionFilter methodDescriptionFilter) {
        if (!methodName.equals(this.method.getName())) {
            return false;
        }
        Type[] methodDescArguments = Type.getArgumentTypes((String)methodDesc);
        if (this.method.getParameterCount() != methodDescArguments.length) {
            return false;
        }
        ResolvedGenericInfo info = this.analyzer.resolveGenerics(clazz);
        if (info == null) {
            return false;
        }
        return methodDescriptionFilter.matchMethodDescription(info, clazz, methodDescArguments, Type.getReturnType((String)methodDesc));
    }

    private boolean matchMainDescription(ResolvedGenericInfo info, Class<?> clazz, Type[] methodDescArguments, Type methodDescReturnType) {
        return this.verifyGenericDescription(info, clazz, methodDescArguments, methodDescReturnType);
    }

    private boolean matchAllDescriptions(ResolvedGenericInfo info, Class<?> clazz, Type[] methodDescArguments, Type methodDescReturnType) {
        Class<?> sensorClass = this.method.getDeclaringClass();
        Class curClass = clazz;
        while (!curClass.equals(sensorClass)) {
            boolean instr = this.verifyGenericDescription(info, curClass, methodDescArguments, methodDescReturnType);
            if (instr) {
                return true;
            }
            Optional<Class> result = Arrays.stream(curClass.getInterfaces()).filter(sensorClass::isAssignableFrom).findAny();
            if (!result.isPresent()) {
                throw new IllegalArgumentException("could not determine relationship between " + sensorClass.getName() + " and " + curClass.getName());
            }
            curClass = result.get();
        }
        return this.verifyGenericDescription(info, curClass, methodDescArguments, methodDescReturnType);
    }

    private boolean verifyGenericDescription(ResolvedGenericInfo info, Class<?> clazz, Type[] methodDescArguments, Type methodDescReturnType) {
        List<Type> actualTypes = info.getResolvedArgumentTypes(this.method, clazz);
        for (int ii = 0; ii < methodDescArguments.length; ++ii) {
            if (actualTypes.get(ii).equals((Object)methodDescArguments[ii])) continue;
            return false;
        }
        return methodDescReturnType.equals((Object)info.getResolvedReturnType(this.method, clazz));
    }

    private static interface MethodDescriptionFilter {
        public boolean matchMethodDescription(ResolvedGenericInfo var1, Class<?> var2, Type[] var3, Type var4);
    }
}

