/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.android.build.api.transform.TransformException;
import com.dynatrace.android.instrumentation.Instrumentor;
import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.sensor.agent.AutoStartTransformation;
import com.dynatrace.android.instrumentation.sensor.agent.ConfigurationPresetSensorFactory;
import com.dynatrace.android.instrumentation.transform.factory.AgentConfigurationTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.HttpClientTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.HttpUrlConnectionTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.HybridAppTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.LifecycleTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.LocationTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.OkHttpTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.UserActionTransformerFactory;
import com.dynatrace.tools.android.dsl.DebugOptions;
import com.dynatrace.tools.android.dsl.HybridOptions;
import com.dynatrace.tools.android.dsl.StartOptions;
import com.dynatrace.tools.android.dsl.UserActionOptions;
import com.dynatrace.tools.android.dsl.UserActionSensors;
import com.dynatrace.tools.android.dsl.VariantConfiguration;
import com.dynatrace.tools.android.dsl.WebRequestOptions;
import com.dynatrace.tools.android.dsl.WebRequestSensors;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentorConfigurator {
    private static final Logger logger = LoggerFactory.getLogger((String)"InstrumentorConfigurator");
    private VariantConfiguration configuration;
    private ExclusionManager exclusionManager;

    public InstrumentorConfigurator(VariantConfiguration configuration, ExclusionManager exclusionManager) {
        this.configuration = configuration;
        this.exclusionManager = exclusionManager;
    }

    public List<TransformerFactory> selectTransformerFactories() {
        Serializable sensors;
        UserActionOptions userActionOptions = this.configuration.getUserActions();
        HybridOptions hybridOptions = this.configuration.getHybridWebView();
        WebRequestOptions webRequestOptions = this.configuration.getWebRequests();
        ArrayList<TransformerFactory> factories = new ArrayList<TransformerFactory>();
        if (!userActionOptions.isEnabled()) {
            logger.debug("Deactivate instrumentation for user action monitoring");
        } else {
            sensors = userActionOptions.getSensors();
            factories.add(new UserActionTransformerFactory(new UserActionTransformerFactory.Sensors.Builder().withOnClickListener(((UserActionSensors)sensors).isClick()).withOnItemClickListener(((UserActionSensors)sensors).isItemClick()).withOnItemSelectedListener(((UserActionSensors)sensors).isItemSelect()).withOnMenuItemClickListener(((UserActionSensors)sensors).isMenuClick()).withOnPageChangeListener(((UserActionSensors)sensors).isPageChange()).withOnRefreshListener(((UserActionSensors)sensors).isRefresh()).withOnOptionsItemSelected(((UserActionSensors)sensors).isOptionSelect()).build()));
        }
        if (!webRequestOptions.isEnabled()) {
            logger.debug("Deactivate instrumentation for web request monitoring");
        } else {
            sensors = webRequestOptions.getSensors();
            if (((WebRequestSensors)sensors).isHttpUrlConnection()) {
                factories.add(new HttpUrlConnectionTransformerFactory());
            } else {
                logger.debug("Deactivate instrumentation for HttpURLConnection web requests");
            }
            if (((WebRequestSensors)sensors).isOkHttp()) {
                factories.add(new OkHttpTransformerFactory());
            } else {
                logger.debug("Deactivate instrumentation for OkHttp web requests");
            }
            if (((WebRequestSensors)sensors).isHttpClient()) {
                factories.add(new HttpClientTransformerFactory());
            } else {
                logger.debug("Deactivate instrumentation for HttpClient web requests");
            }
        }
        factories.add(new LifecycleTransformerFactory());
        if (hybridOptions.isEnabled()) {
            factories.add(new HybridAppTransformerFactory());
        } else {
            logger.debug("Deactivate instrumentation for hybrid web view monitoring");
        }
        if (this.configuration.isLocationMonitoring()) {
            factories.add(new LocationTransformerFactory());
        } else {
            logger.debug("Deactivate instrumentation for location monitoring");
        }
        factories.add(new AgentConfigurationTransformerFactory(this.generateBuilderConfiguration(), this.generatePresetConfiguration()));
        return factories;
    }

    @VisibleForTesting
    AutoStartTransformation.BuilderConfiguration generateBuilderConfiguration() {
        StartOptions startOptions = this.configuration.getAutoStart();
        if (!startOptions.isEnabled()) {
            return null;
        }
        boolean isSaas = startOptions.getBeaconUrl() != null;
        return new AutoStartTransformation.BuilderConfiguration(startOptions.getApplicationId(), isSaas ? startOptions.getBeaconUrl() : startOptions.getAgentPath(), isSaas);
    }

    @VisibleForTesting
    ConfigurationPresetSensorFactory.PresetConfiguration generatePresetConfiguration() {
        StartOptions startOptions = this.configuration.getAutoStart();
        UserActionOptions userActionOptions = this.configuration.getUserActions();
        HybridOptions hybridOptions = this.configuration.getHybridWebView();
        WebRequestOptions webRequestOptions = this.configuration.getWebRequests();
        DebugOptions debugOptions = this.configuration.getDebug();
        return new ConfigurationPresetSensorFactory.PresetConfiguration(debugOptions.isCertificateValidation(), userActionOptions.getTimeout(), userActionOptions.getMaxDuration(), userActionOptions.isEmptyActions(), this.configuration.getLifecycle().isEnabled() && this.configuration.getLifecycle().getSensors().isApplication(), this.configuration.getLifecycle().isEnabled() && this.configuration.getLifecycle().getSensors().isActivity(), this.configuration.isCrashReporting(), webRequestOptions.isEnabled(), hybridOptions.getDomains().toArray(new String[0]), false, hybridOptions.isEnabled(), debugOptions.isAgentLogging(), startOptions.isEnabled(), this.configuration.isUserOptIn());
    }

    public Instrumentor generateVariantSpecificInstrumentor(URLClassLoader classLoader, Consumer<byte[]> verificationConsumer) throws TransformException {
        try {
            return new Instrumentor.Builder().setClassLoader(classLoader).setTransformerFactories(this.selectTransformerFactories()).shouldPerformAsmVerify(this.configuration.getDebug().isByteCodeVerification()).setVerificationConsumer(verificationConsumer).setExclusionManager(this.exclusionManager).setWarningsAsErrors(this.configuration.getDebug().isFailOnWarnings()).build();
        }
        catch (Exception e) {
            throw new TransformException("Unable to instantiate instrumentor, Please open a support ticket", (Throwable)e);
        }
    }
}

