/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.dsl;

import com.dynatrace.tools.android.dsl.ExcludeFilterOptions;
import com.dynatrace.tools.android.dsl.ExcludeOptions;
import com.dynatrace.tools.android.dsl.LifecycleOptions;
import com.dynatrace.tools.android.dsl.LifecycleSensors;
import com.dynatrace.tools.android.dsl.StartOptions;
import com.dynatrace.tools.android.dsl.UserActionOptions;
import com.dynatrace.tools.android.dsl.UserActionSensors;
import com.dynatrace.tools.android.dsl.VariantConfiguration;
import com.dynatrace.tools.android.dsl.WebRequestOptions;
import com.dynatrace.tools.android.dsl.WebRequestSensors;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public final class VerificationUtil {
    private VerificationUtil() {
    }

    private static void verifyStringValue(String value, String errorMsgPrefix, String propertyValue) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException(errorMsgPrefix + "Invalid value for property '" + propertyValue + "'");
        }
    }

    private static void verifyStringValues(List<String> values, String errorMsgPrefix, String propertyValue) {
        if (values == null) {
            throw new IllegalArgumentException(errorMsgPrefix + "Invalid value for property '" + propertyValue + "'");
        }
        if (values.size() == 0) {
            throw new IllegalArgumentException(errorMsgPrefix + "Empty collection for property '" + propertyValue + "'");
        }
        VerificationUtil.verifyListContent(values, errorMsgPrefix, propertyValue);
    }

    private static void verifyOptionalStringValues(List<String> values, String errorMsgPrefix, String propertyValue) {
        if (values == null) {
            throw new IllegalArgumentException(errorMsgPrefix + "Invalid value for property '" + propertyValue + "'");
        }
        VerificationUtil.verifyListContent(values, errorMsgPrefix, propertyValue);
    }

    private static void verifyListContent(List<String> values, String errorMsgPrefix, String propertyValue) {
        for (String value : values) {
            if (value != null && !value.trim().isEmpty()) continue;
            throw new IllegalArgumentException(errorMsgPrefix + "Property '" + propertyValue + "' contains an invalid value");
        }
    }

    private static void verifyIntValue(int value, String errorMsgPrefix, String propertyValue, int lowerBorder, int upperBorder) {
        if (value < lowerBorder) {
            throw new IllegalArgumentException(errorMsgPrefix + "For property '" + propertyValue + "' values below " + lowerBorder + " are not accepted");
        }
        if (value > upperBorder) {
            throw new IllegalArgumentException(errorMsgPrefix + "For property '" + propertyValue + "' values above " + upperBorder + " are not accepted");
        }
    }

    private static void verifyURLValue(String value, String errorMsgPrefix, String propertyValue, boolean mustHavePath) {
        VerificationUtil.verifyStringValue(value, errorMsgPrefix, propertyValue);
        try {
            boolean validPath;
            URL url = new URL(value);
            boolean isHttpProtocol = url.getProtocol().equals("https") || url.getProtocol().equals("http");
            boolean bl = validPath = !mustHavePath || url.getPath().length() > 0;
            if (!isHttpProtocol || !validPath || url.getQuery() != null || url.getRef() != null) {
                throw new IllegalArgumentException(errorMsgPrefix + "Invalid URL value for property '" + propertyValue + "'");
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(errorMsgPrefix + "Invalid URL value for property '" + propertyValue + "'", e);
        }
    }

    public static void verifyVariantConfiguration(VariantConfiguration variantConfiguration) {
        LifecycleSensors sensors;
        WebRequestSensors sensors2;
        WebRequestOptions webRequestOptions;
        UserActionOptions userActionOptions;
        if (!variantConfiguration.isEnabled()) {
            return;
        }
        String errorMsgPrefix = "Invalid configuration '" + variantConfiguration.getName() + "': ";
        StartOptions autoStartOptions = variantConfiguration.getAutoStart();
        if (!autoStartOptions.isEnabled()) {
            if (autoStartOptions.getApplicationId() != null || autoStartOptions.getBeaconUrl() != null || autoStartOptions.getAgentPath() != null) {
                throw new IllegalArgumentException(errorMsgPrefix + "The agent startup parameters must be defined via the configuration builder in the Dynatrace.startup method");
            }
        } else {
            VerificationUtil.verifyStringValue(autoStartOptions.getApplicationId(), errorMsgPrefix, "applicationId");
            boolean hasOnlyOneMonitorPathValue = autoStartOptions.getBeaconUrl() != null ^ autoStartOptions.getAgentPath() != null;
            if (!hasOnlyOneMonitorPathValue) {
                throw new IllegalArgumentException(errorMsgPrefix + "You have to use either the property 'beaconUrl' or 'agentPath'");
            }
            if (autoStartOptions.getBeaconUrl() != null) {
                VerificationUtil.verifyURLValue(autoStartOptions.getBeaconUrl(), errorMsgPrefix, "beaconUrl", true);
            } else {
                VerificationUtil.verifyURLValue(autoStartOptions.getAgentPath(), errorMsgPrefix, "agentPath", false);
            }
        }
        if ((userActionOptions = variantConfiguration.getUserActions()).isEnabled()) {
            UserActionSensors sensors3 = userActionOptions.getSensors();
            if (!sensors3.hasActiveSensors()) {
                throw new IllegalArgumentException(errorMsgPrefix + "User action monitoring is enabled but all sensors are deactivated");
            }
            VerificationUtil.verifyIntValue(userActionOptions.getTimeout(), errorMsgPrefix, "timeout", 100, 5000);
            VerificationUtil.verifyIntValue(userActionOptions.getMaxDuration(), errorMsgPrefix, "maxDuration", 100, 540000);
            if (userActionOptions.getMaxDuration() < userActionOptions.getTimeout()) {
                throw new IllegalArgumentException(errorMsgPrefix + "Property 'maxDuration' must be greater than the property 'timeout'");
            }
        }
        if ((webRequestOptions = variantConfiguration.getWebRequests()).isEnabled() && !(sensors2 = webRequestOptions.getSensors()).hasActiveSensors()) {
            throw new IllegalArgumentException(errorMsgPrefix + "Web request monitoring is enabled but all sensors are deactivated");
        }
        LifecycleOptions lifecycleOptions = variantConfiguration.getLifecycle();
        if (lifecycleOptions.isEnabled() && !(sensors = lifecycleOptions.getSensors()).hasActiveSensors()) {
            throw new IllegalArgumentException(errorMsgPrefix + "Lifecycle monitoring is enabled but all sensors are deactivated");
        }
        ExcludeOptions excludeOptions = variantConfiguration.getExclude();
        VerificationUtil.verifyOptionalStringValues(excludeOptions.getPackages(), errorMsgPrefix, "packages");
        VerificationUtil.verifyOptionalStringValues(excludeOptions.getClasses(), errorMsgPrefix, "classes");
        VerificationUtil.verifyOptionalStringValues(excludeOptions.getMethods(), errorMsgPrefix, "methods");
        for (ExcludeFilterOptions filter : excludeOptions.getFilter()) {
            VerificationUtil.verifyStringValue(filter.getClassName(), errorMsgPrefix, "className");
            VerificationUtil.verifyStringValue(filter.getMethodName(), errorMsgPrefix, "methodName");
            VerificationUtil.verifyStringValue(filter.getMethodDescription(), errorMsgPrefix, "methodDescription");
        }
    }
}

