/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.method;

import com.dynatrace.android.instrumentation.sensor.method.ExitMethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.MethodFilter;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class MethodSensorImpl
implements MethodSensor {
    private MethodFilter filter;
    private List<MethodTransformation> transformations;

    public MethodSensorImpl(Method method, MethodTransformation ... transformations) {
        this(method, Arrays.asList(transformations));
    }

    public MethodSensorImpl(Method method, List<MethodTransformation> transformations) {
        this(method.getName(), Type.getType((Method)method).getDescriptor(), transformations);
    }

    public MethodSensorImpl(Constructor<?> constructor, MethodTransformation ... transformations) {
        this("<init>", Type.getType(constructor).getDescriptor(), transformations);
    }

    public MethodSensorImpl(String name, String desc, MethodTransformation ... transformations) {
        this(name, desc, Arrays.asList(transformations));
    }

    public MethodSensorImpl(String name, String desc, List<MethodTransformation> transformations) {
        this((Class<?> clazz, String methodName, String methodDesc, boolean isLambda) -> methodName.equals(name) && methodDesc.equals(desc), transformations);
    }

    public MethodSensorImpl(MethodFilter filter, MethodTransformation ... transformations) {
        this(filter, Arrays.asList(transformations));
    }

    public MethodSensorImpl(MethodFilter filter, List<MethodTransformation> transformations) {
        this.filter = filter;
        this.transformations = transformations;
    }

    public static List<MethodTransformation> generateDefaultMethodTransformer(Method startSensorMethod, Method exitSensorMethod) {
        return Arrays.asList(new ExitMethodTransformation(exitSensorMethod, null), new StartMethodTransformation(startSensorMethod, ParameterInstructionProvider.withAllParameters(startSensorMethod)));
    }

    @Override
    public boolean matchMethod(Class<?> clazz, String methodName, String desc, boolean isLambda) {
        return this.filter.matchMethod(clazz, methodName, desc, isLambda);
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        for (MethodTransformation transformation : this.transformations) {
            transformation.transformMethod(methodNode, startParameterIndex);
        }
    }
}

