/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.dynatrace.tools.android.InstrumentationPlugin;
import com.dynatrace.tools.android.Version;
import com.dynatrace.tools.android.dsl.DynatraceExtension;
import com.dynatrace.tools.android.util.Utils;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ObjectConfigurationAction;
import org.gradle.internal.reflect.Instantiator;

public class DynatracePlugin
implements Plugin<Project> {
    private final Instantiator instantiator;

    @Inject
    public DynatracePlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public static String agentDependency() {
        return "com.dynatrace.agent:agent-android:" + Version.getVersion() + "@aar";
    }

    private static void configureSubProjects(Project project) {
        Action appliedPluginAction = appliedPlugin -> project.apply(DynatracePlugin::applyPlugin);
        project.getPluginManager().withPlugin("com.android.application", appliedPluginAction);
        project.getPluginManager().withPlugin("com.android.dynamic-feature", appliedPluginAction);
    }

    private static void applyPlugin(ObjectConfigurationAction objectConfigurationAction) {
        objectConfigurationAction.plugin(InstrumentationPlugin.class);
    }

    public void apply(Project project) {
        Utils.verifyGradleVersion();
        Utils.determineAndVerifyAGPVersion();
        if (Utils.isOldPluginApplied()) {
            throw new GradleException("Your build script classpath also contains an older version of the Dynatrace Android Gradle plugin. You must remove the old version from your build script classpath.");
        }
        project.getExtensions().create("dynatrace", DynatraceExtension.class, new Object[]{project, this.instantiator});
        project.subprojects(DynatracePlugin::configureSubProjects);
    }
}

