/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.classpath;

import java.lang.reflect.Method;

public class ClassPathAnalyzer {
    private ClassLoader classLoader;

    public ClassPathAnalyzer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private boolean containsClasses(String ... names) {
        try {
            for (String name : names) {
                Class.forName(name, false, this.classLoader);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean containsCompuwareAgent() {
        return this.containsClasses("com.compuware.android.app.Activity") || this.containsClasses("com.compuware.apm.uem.mobile.android.CompuwareUEM");
    }

    public boolean containsInstrumentationLibraries() {
        return this.containsClasses("com.dynatrace.android.callback.Callback");
    }

    public String determineAgentVersion() {
        try {
            Class<?> clazzAgentVersion = Class.forName("com.dynatrace.android.agent.Version", true, this.classLoader);
            Method method = clazzAgentVersion.getDeclaredMethod("getFullVersion", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

