/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.transformation;

import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformException;
import com.dynatrace.android.instrumentation.IncrementalStateVerifier;
import com.dynatrace.android.instrumentation.Instrumentor;
import com.dynatrace.android.instrumentation.InvalidIncrementalStateException;
import com.dynatrace.tools.android.IncrementalStateTrackerGroup;
import com.dynatrace.tools.android.transformation.BuildArtifactTransformer;
import com.dynatrace.tools.android.transformation.BuildHandler;
import com.dynatrace.tools.android.transformation.FileTransformer;
import com.dynatrace.tools.android.transformation.JarTransformer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentedBuild
implements BuildHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"InstrumentedBuild");
    private Instrumentor instrumentor;
    private IncrementalStateTrackerGroup tracker;

    public InstrumentedBuild(Instrumentor instrumentor, IncrementalStateTrackerGroup tracker) {
        this.instrumentor = instrumentor;
        this.tracker = tracker;
    }

    @Override
    public Consumer<String> getFileRemovedListener(String name) {
        return className -> this.tracker.removeClass(name, (String)className);
    }

    @Override
    public FileTransformer getFileTransformer(String name, Status status) {
        return (source, dest, className) -> this.transformFile(source, dest, className, this.tracker.getVerifier(name, status == Status.CHANGED));
    }

    private void transformFile(Path source, Path dest, String className, IncrementalStateVerifier verifier) throws InvalidIncrementalStateException, TransformException, IOException {
        this.transformContent(() -> Files.readAllBytes(source), bytes -> Files.write(dest, bytes, new OpenOption[0]), className, verifier);
    }

    private void transformContent(BytesReader reader, BytesWriter writer, String className, IncrementalStateVerifier verifier) throws InvalidIncrementalStateException, TransformException {
        try {
            writer.write(this.instrumentor.instrument(className, reader.read(), verifier));
        }
        catch (InvalidIncrementalStateException e) {
            throw e;
        }
        catch (UnsupportedClassVersionError e) {
            throw new TransformException("Unable to instrument class " + className + " because it was compiled with a higher Java version than the one used for this build. Please adapt your JRE accordingly to https://www.dynatrace.com/support/help/shortlink/dynatrace-android-gradle-plugin-overview#requirements", (Throwable)e);
        }
        catch (IOException e) {
            throw new TransformException("Unable to instrument class " + className, (Throwable)e);
        }
        catch (Exception e) {
            throw new TransformException("Unable to instrument class " + className + ". Please open a support ticket", (Throwable)e);
        }
    }

    @Override
    public Consumer<Path> getJarRemovedListener(String name) {
        return jarName -> this.tracker.removeGroup(name);
    }

    @Override
    public JarTransformer getJarTransformer(String name, Status status) {
        return (source, dest) -> this.transformJar(source, dest, this.tracker.getJarVerifier(name, status == Status.CHANGED));
    }

    private void transformJar(Path jarFile, Path output, IncrementalStateVerifier verifier) throws IOException, InvalidIncrementalStateException, TransformException {
        try (FileOutputStream fos = new FileOutputStream(output.toFile());
             JarOutputStream jos = new JarOutputStream(fos);
             JarFile jar = new JarFile(jarFile.toFile());){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry == null) continue;
                if (entry.isDirectory()) {
                    logger.debug("Ignore directory " + entry.getName());
                    continue;
                }
                if (!entry.getName().endsWith(".class")) {
                    logger.debug("Ignore non class file " + entry.getName());
                    continue;
                }
                logger.debug("Store jar entry " + entry.getName());
                jos.putNextEntry(new JarEntry(entry.getName()));
                try (InputStream is = jar.getInputStream(entry);){
                    String className = BuildArtifactTransformer.convertFileNameToClassName(entry.getName());
                    this.transformContent(() -> IOUtils.toByteArray((InputStream)is), jos::write, className, verifier);
                }
                jos.closeEntry();
            }
        }
    }

    static interface BytesReader {
        public byte[] read() throws IOException;
    }

    static interface BytesWriter {
        public void write(byte[] var1) throws IOException;
    }
}

