/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.AppExtension;
import com.dynatrace.android.instrumentation.Instrumentor;
import com.dynatrace.android.instrumentation.InvalidIncrementalStateException;
import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.tools.android.IncrementalStateTrackerGroup;
import com.dynatrace.tools.android.InstrumentorConfigurator;
import com.dynatrace.tools.android.classpath.ClassPathAnalyzer;
import com.dynatrace.tools.android.classpath.ClassPathGenerator;
import com.dynatrace.tools.android.dsl.DynatraceExtension;
import com.dynatrace.tools.android.dsl.VariantConfiguration;
import com.dynatrace.tools.android.dsl.VariantConfigurationUtil;
import com.dynatrace.tools.android.transformation.BuildArtifactTransformer;
import com.dynatrace.tools.android.transformation.InstrumentedBuild;
import com.dynatrace.tools.android.transformation.NonInstrumentedBuild;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynatraceTransformer
extends Transform {
    private static final Logger logger = LoggerFactory.getLogger((String)"DynatraceTransformer");
    private DynatraceExtension extension;
    private AppExtension appExtension;
    private String fileSerializationName;
    private File dumpFile;
    private Map<String, VariantConfiguration> variantSpecificConfiguration;

    DynatraceTransformer(DynatraceExtension extension, AppExtension appExtension) {
        this.extension = extension;
        this.appExtension = appExtension;
        this.variantSpecificConfiguration = new HashMap<String, VariantConfiguration>();
    }

    public String getName() {
        return "dynatraceTransformer";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT, (Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Object)QualifiedContent.Scope.SUB_PROJECTS);
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return ImmutableSet.of((Object)QualifiedContent.Scope.PROVIDED_ONLY);
    }

    public boolean isIncremental() {
        return true;
    }

    public Map<String, Object> getParameterInputs() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isPluginEnabled", this.extension.isPluginEnabled());
        map.put("isStrictMode", this.extension.isStrictMode());
        return map;
    }

    public boolean isCacheable() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, IOException {
        boolean isIncremental;
        VariantConfiguration configuration = null;
        if (!this.extension.isPluginEnabled()) {
            logger.debug("Dynatrace Android Gradle plugin is disabled");
        } else {
            String variantName = transformInvocation.getContext().getVariantName();
            configuration = this.variantSpecificConfiguration.get(variantName);
            if (configuration == null) {
                if (variantName.endsWith("AndroidTest")) {
                    logger.debug("Deactivate transformation for androidTest artifacts");
                } else {
                    if (this.extension.isStrictMode()) {
                        throw new IllegalArgumentException("Variant '" + variantName + "' has no matching configuration");
                    }
                    logger.debug("Variant '{}' has no matching configuration", (Object)variantName);
                }
            } else {
                logger.debug("Variant '{}' will use configuration '{}'", (Object)variantName, (Object)configuration.getName());
                logger.debug("{}", (Object)configuration);
                if (!configuration.isEnabled()) {
                    logger.debug("Instrumentation is disabled");
                    configuration = null;
                }
            }
        }
        File tempDir = transformInvocation.getContext().getTemporaryDir();
        this.fileSerializationName = tempDir.getAbsolutePath() + File.separator + "transform.ser";
        this.dumpFile = new File(tempDir, "error.class.dump");
        if (this.dumpFile.exists()) {
            this.dumpFile.delete();
        }
        String txtIncremental = (isIncremental = transformInvocation.isIncremental()) ? "incremental" : "non-incremental";
        logger.debug("Start " + txtIncremental + " transformation");
        try {
            this.transform(transformInvocation, isIncremental, configuration);
        }
        catch (InvalidIncrementalStateException e) {
            if (!isIncremental) {
                throw new TransformException("Unexpected error obtained. Please open a support ticket", (Throwable)e);
            }
            logger.debug("Switch from incremental to non-incremental transformation");
            try {
                this.transform(transformInvocation, false, configuration);
            }
            catch (InvalidIncrementalStateException e1) {
                throw new TransformException("Unexpected error obtained. Please open a support ticket", (Throwable)e);
            }
        }
    }

    private void transform(TransformInvocation transformInvocation, boolean isIncremental, VariantConfiguration configuration) throws TransformException, IOException, InvalidIncrementalStateException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        if (!isIncremental) {
            logger.debug("Delete all files for non-incremental build");
            outputProvider.deleteAll();
        }
        if (configuration == null) {
            File fileSerialization = new File(this.fileSerializationName);
            if (fileSerialization.exists()) {
                fileSerialization.delete();
            }
            new BuildArtifactTransformer(new NonInstrumentedBuild(), isIncremental).handleTransformation(transformInvocation);
        } else {
            IncrementalStateTrackerGroup tracker = IncrementalStateTrackerGroup.create(this.fileSerializationName, isIncremental);
            ClassPathGenerator classPathGenerator = new ClassPathGenerator(this.appExtension.getBootClasspath(), transformInvocation.getInputs(), transformInvocation.getReferencedInputs());
            try (URLClassLoader classLoader = URLClassLoader.newInstance((URL[])classPathGenerator.get(), null);){
                Instrumentor instrumentor;
                logger.debug("classLoader content " + Arrays.toString(classLoader.getURLs()));
                new ClassPathAnalyzer(classLoader).verifyClassPath();
                ExclusionManager exclusionManager = VariantConfigurationUtil.generateExclusionManager(configuration);
                try {
                    instrumentor = new InstrumentorConfigurator(configuration, exclusionManager).generateVariantSpecificInstrumentor(classLoader, this::dumpClass);
                }
                catch (Exception e) {
                    throw new TransformException("Unable to instantiate instrumentor, Please open a support ticket", (Throwable)e);
                }
                new BuildArtifactTransformer(new InstrumentedBuild(instrumentor, tracker), isIncremental).handleTransformation(transformInvocation);
                tracker.store();
                Set<String> exclusionReport = exclusionManager.getExclusionReport();
                if (!exclusionReport.isEmpty()) {
                    logger.debug("The following classes/methods have been excluded from instrumentation:");
                    exclusionReport.stream().sorted(String::compareTo).forEach(s -> logger.debug("  " + s));
                }
            }
        }
    }

    private void dumpClass(byte[] bytes) {
        try (FileOutputStream out = new FileOutputStream(this.dumpFile);){
            ((OutputStream)out).write(bytes);
            out.flush();
        }
        catch (IOException ioe) {
            logger.info("unable to dump class file", (Throwable)ioe);
        }
    }

    public void addVariantSpecificConfiguration(String name, VariantConfiguration variantConfiguration) {
        this.variantSpecificConfiguration.put(name, variantConfiguration);
    }
}

