/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class SensorGroupImpl<T>
implements SensorGroup<T> {
    private String key;
    private Predicate<Class<?>> clazzMatcher;
    private List<T> sensors;

    public SensorGroupImpl(String key, Class<?> clazz, List<T> sensors) {
        this(key, clazz::isAssignableFrom, sensors);
    }

    public SensorGroupImpl(String key, Class<?> clazz, T ... sensors) {
        this(key, clazz, Arrays.asList(sensors));
    }

    public SensorGroupImpl(String key, Predicate<Class<?>> clazzMatcher, List<T> sensors) {
        this.key = key;
        this.clazzMatcher = clazzMatcher;
        this.sensors = sensors;
    }

    public SensorGroupImpl(String key, Predicate<Class<?>> clazzMatcher, T ... sensors) {
        this(key, clazzMatcher, Arrays.asList(sensors));
    }

    @Override
    public boolean matchClass(Class<?> clazz) {
        return this.clazzMatcher.test(clazz);
    }

    @Override
    public List<T> getSensors() {
        return this.sensors;
    }

    @Override
    public String getKey() {
        return this.key;
    }
}

