/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.agent;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.agent.AgentStateListenerFactorySensor;
import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavorTranslation;
import com.dynatrace.android.instrumentation.sensor.agent.PresetConfiguration;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.util.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationPresetSensorFactory {
    public static final String CONFIG_PRESET_CLASS = "com.dynatrace.android.agent.conf.ConfigurationPreset";
    public static final String INSTRUMENTATION_FLAVOR_CLASS = "com.dynatrace.android.agent.conf.InstrumentationFlavor";
    private final PresetConfiguration presetConfig;

    public ConfigurationPresetSensorFactory(PresetConfiguration config) {
        this.presetConfig = config;
    }

    public SensorGroup<MethodSensor> generateConfigurationPresetSensor(ClassLoader classLoader) throws Exception {
        Class<?> configPresetClass = Class.forName(CONFIG_PRESET_CLASS, false, classLoader);
        return new SensorGroupImpl<MethodSensor>("ConfigurationPresetSensor", otherClass -> configPresetClass == otherClass, this.getMethodList(classLoader));
    }

    private List<MethodSensor> getMethodList(ClassLoader classLoader) throws NoSuchMethodException, ClassNotFoundException {
        Class<?> agentInstrumentationFlavorClass = Class.forName(INSTRUMENTATION_FLAVOR_CLASS, false, classLoader);
        Enum<Enum<?>> translatedInstrumentationFlavor = Utils.translateEnum(agentInstrumentationFlavorClass, this.presetConfig.getInstrumentationFlavor(), new InstrumentationFlavorTranslation());
        ArrayList<MethodSensor> sensors = new ArrayList<MethodSensor>();
        sensors.add(new MethodSensorImpl(this.findGetter("getGraceTime", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.getGraceTime())));
        sensors.add(new MethodSensorImpl(this.findGetter("getWaitTime", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.getWaitTime())));
        sensors.add(new MethodSensorImpl(this.findGetter("getApplicationMonitoring", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isApplicationMonitoring())));
        sensors.add(new MethodSensorImpl(this.findGetter("getActivityMonitoring", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isActivityMonitoring())));
        sensors.add(new MethodSensorImpl(this.findGetter("getCertificateValidation", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isCertificateValidation())));
        sensors.add(new MethodSensorImpl(this.findGetter("getSendEmptyActions", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isSendEmptyActions())));
        sensors.add(new MethodSensorImpl(this.findGetter("getCrashReporting", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isCrashReporting())));
        sensors.add(new MethodSensorImpl(this.findGetter("getWebRequestTiming", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isWebRequestTiming())));
        sensors.add(new MethodSensorImpl(this.findGetter("getMonitoredDomains", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.getMonitoredDomains())));
        sensors.add(new MethodSensorImpl(this.findGetter("getNoSendInBg", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isNoSendInBg())));
        sensors.add(new MethodSensorImpl(this.findGetter("getHybridApp", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isHybridApp())));
        sensors.add(new MethodSensorImpl(this.findGetter("getDebugLogLevel", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isDebugLogLevel())));
        sensors.add(new MethodSensorImpl(this.findGetter("getAutoStart", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isAutoStart())));
        sensors.add(new MethodSensorImpl(this.findGetter("getUserOptIn", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isUserOptIn())));
        sensors.add(new MethodSensorImpl(this.findGetter("getStartupLoadBalancing", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isStartupLoadBalancing())));
        sensors.add(new MethodSensorImpl(this.findGetter("getInstrumentationFlavor", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, translatedInstrumentationFlavor)));
        if (this.presetConfig.isSessionReplayEnabled()) {
            sensors.add(new MethodSensorImpl(this.findGetter("getAgentStateListenerFactory", classLoader), new AgentStateListenerFactorySensor()));
        }
        sensors.add(new MethodSensorImpl(this.findGetter("isRageTapDetectionEnabled", classLoader), (methodNode, index) -> Utils.replaceGetterInstructions(methodNode.instructions, this.presetConfig.isRageTapDetection())));
        return sensors;
    }

    private Method findGetter(String name, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        return Class.forName(CONFIG_PRESET_CLASS, false, classLoader).getDeclaredMethod(name, new Class[0]);
    }
}

