/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertAfterInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.ReplaceInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;

public class HttpUrlConnectionTransformerFactory
implements TransformerFactory {
    private static final String HTTP_URL_CONNECTION = "java.net.HttpURLConnection";
    private static final String URL_CONNECTION = "java.net.URLConnection";
    private static final String URL = "java.net.URL";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
        instructionSensors.add(this.generateHttpUrlConnectionSensors(classLoader));
        instructionSensors.add(this.generateUrlConnectionSensors(classLoader));
        instructionSensors.add(this.generateUrlSensors(classLoader));
        return new DefaultSubTransformer("HttpUrlConnectionTransformer", instructionSensors, new ArrayList<SensorGroup<MethodSensor>>(), classLoader, warningsAsErrors);
    }

    private SensorGroup<InstructionSensor> generateHttpUrlConnectionSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> urlConnection = Class.forName(URL_CONNECTION, false, classLoader);
        Class<?> connection = Class.forName(HTTP_URL_CONNECTION, false, classLoader);
        Method getResponseCode = connection.getDeclaredMethod("getResponseCode", new Class[0]);
        Method getInputStream = urlConnection.getDeclaredMethod("getInputStream", new Class[0]);
        Method getOutputStream = urlConnection.getDeclaredMethod("getOutputStream", new Class[0]);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.Callback", false, classLoader);
        Method instr_getResponseCode = callback.getDeclaredMethod("getResponseCode", connection);
        Method instr_getInputStream = callback.getDeclaredMethod("getInputStream", connection);
        Method instr_getOutputStream = callback.getDeclaredMethod("getOutputStream", connection);
        Method instr_newInstance = callback.getDeclaredMethod("newInstance", connection);
        return new SensorGroupImpl<InstructionSensor>("HttpUrlConnectionSensor", connection, new ReplaceInstructionSensor(getResponseCode, instr_getResponseCode), new ReplaceInstructionSensor(getInputStream, instr_getInputStream), new ReplaceInstructionSensor(getOutputStream, instr_getOutputStream), new InsertAfterInstructionSensor("<init>", instructions -> {
            instructions.add((AbstractInsnNode)new InsnNode(89));
            instructions.add((AbstractInsnNode)Utils.generateMethodCall(instr_newInstance));
        }));
    }

    private SensorGroup<InstructionSensor> generateUrlConnectionSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> connection = Class.forName(URL_CONNECTION, false, classLoader);
        Method getInputStream = connection.getDeclaredMethod("getInputStream", new Class[0]);
        Method getOutputStream = connection.getDeclaredMethod("getOutputStream", new Class[0]);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.Callback", false, classLoader);
        Method instr_getInputStream = callback.getDeclaredMethod("getInputStream", connection);
        Method instr_getOutputStream = callback.getDeclaredMethod("getOutputStream", connection);
        return new SensorGroupImpl<InstructionSensor>("UrlConnectionSensor", otherClazz -> connection == otherClazz, new ReplaceInstructionSensor(getInputStream, instr_getInputStream), new ReplaceInstructionSensor(getOutputStream, instr_getOutputStream));
    }

    private SensorGroup<InstructionSensor> generateUrlSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> url = Class.forName(URL, false, classLoader);
        Method openConnection = url.getDeclaredMethod("openConnection", new Class[0]);
        Class<?> connection = Class.forName(URL_CONNECTION, false, classLoader);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.Callback", false, classLoader);
        Method instr_openConnection = callback.getDeclaredMethod("openConnection", connection);
        return new SensorGroupImpl<InstructionSensor>("UrlSensor", otherClazz -> url == otherClazz, new InsertAfterInstructionSensor(openConnection, instructions -> {
            instructions.add((AbstractInsnNode)new InsnNode(89));
            instructions.add((AbstractInsnNode)Utils.generateMethodCall(instr_openConnection));
        }));
    }
}

