/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionReplayFragmentTransformerFactory
implements TransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"SessionReplayFragmentTransformerFactory");
    private static final String ANDROID_FRAGMENT = "androidx.fragment.app.Fragment";
    private static final String ANDROID_VIEW = "android.view.View";
    private static final String ANDROID_BUNDLE = "android.os.Bundle";
    private static final String ANDROID_CONTEXT = "android.content.Context";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        try {
            ArrayList<SensorGroup<MethodSensor>> sensors = new ArrayList<SensorGroup<MethodSensor>>();
            sensors.add(this.generateAndroidXFragmentSensors(classLoader));
            return new DefaultSubTransformer("SessionReplayFragmentTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), sensors, classLoader, warningsAsErrors);
        }
        catch (ClassNotFoundException e) {
            logger.debug("Deactivate instrumentation for (androidx) Fragment events, because it is not part of the classpath");
            return null;
        }
    }

    private SensorGroup<MethodSensor> generateAndroidXFragmentSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> fragment = Class.forName(ANDROID_FRAGMENT, false, classLoader);
        Class<?> view = Class.forName(ANDROID_VIEW, false, classLoader);
        Class<?> bundle = Class.forName(ANDROID_BUNDLE, false, classLoader);
        Class<?> context = Class.forName(ANDROID_CONTEXT, false, classLoader);
        Class<?> object = Class.forName(Object.class.getName(), false, classLoader);
        Method onViewCreated = fragment.getDeclaredMethod("onViewCreated", view, bundle);
        Method onCreateAnimation = fragment.getDeclaredMethod("onCreateAnimation", Integer.TYPE, Boolean.TYPE, Integer.TYPE);
        Method onCreateAnimator = fragment.getDeclaredMethod("onCreateAnimator", Integer.TYPE, Boolean.TYPE, Integer.TYPE);
        Class<?> callback = Class.forName("com.dynatrace.android.internal.api.InstrumentorAPI", false, classLoader);
        Method instrumentOnViewCreated = callback.getDeclaredMethod("fragmentViewCreated", object, view, bundle);
        Method instrumentOnAnimation = callback.getDeclaredMethod("onCreateFragmentAnimation", object, Integer.TYPE, Boolean.TYPE, Integer.TYPE, context);
        Method instrumentOnAnimator = callback.getDeclaredMethod("onCreateFragmentAnimator", object, Integer.TYPE, Boolean.TYPE, Integer.TYPE, context);
        Method getContext = fragment.getDeclaredMethod("getContext", new Class[0]);
        ParameterInstructionProvider provider = (instructions, startParameterIndex) -> {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, startParameterIndex));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, startParameterIndex + 1));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, startParameterIndex + 2));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)Utils.generateMethodCall(getContext));
        };
        return new SensorGroupImpl<MethodSensor>("SRFragmentSensor", clazz -> clazz == fragment, new MethodSensorImpl(onViewCreated, new StartMethodTransformation(instrumentOnViewCreated, ParameterInstructionProvider.withThisAndAllParameters(onViewCreated))), new MethodSensorImpl(onCreateAnimation, new ReplaceInsnListTransformation(instrumentOnAnimation, provider)), new MethodSensorImpl(onCreateAnimator, new ReplaceInsnListTransformation(instrumentOnAnimator, provider)));
    }

    private static class ReplaceInsnListTransformation
    implements MethodTransformation {
        private final Method instrumentedMethod;
        private final ParameterInstructionProvider paramInstructionProvider;

        public ReplaceInsnListTransformation(Method instrumentedMethod, ParameterInstructionProvider paramInstructionProvider) {
            this.instrumentedMethod = instrumentedMethod;
            this.paramInstructionProvider = paramInstructionProvider;
        }

        @Override
        public void transformMethod(MethodNode methodNode, int startParameterIndex) {
            InsnList instructions = methodNode.instructions;
            instructions.clear();
            this.paramInstructionProvider.addParameterInstructions(instructions, startParameterIndex);
            instructions.add((AbstractInsnNode)Utils.generateMethodCall(this.instrumentedMethod));
            instructions.add((AbstractInsnNode)new InsnNode(176));
        }
    }
}

