/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.instrumentor;

import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.method.MandatoryMethodSensor;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MandatoryMethodInstrumentor {
    private static final Logger logger = LoggerFactory.getLogger((String)"MandatoryMethodInstrumentor");
    private List<SensorGroup<MandatoryMethodSensor>> sensors;
    private boolean warningsAsErrors;

    public MandatoryMethodInstrumentor(List<SensorGroup<MandatoryMethodSensor>> sensors, boolean warningsAsErrors) {
        this.sensors = sensors;
        this.warningsAsErrors = warningsAsErrors;
    }

    public boolean transformClass(Class<?> clazz, ClassNode classNode, ExclusionManager exclusionManager) {
        boolean modified = false;
        for (SensorGroup<MandatoryMethodSensor> sensorGroup : this.sensors) {
            if (!sensorGroup.matchClass(clazz)) continue;
            for (MandatoryMethodSensor methodSensor : sensorGroup.getSensors()) {
                MethodNode methodNode2;
                Optional<MethodNode> result = classNode.methods.stream().filter(methodNode -> methodSensor.matchMethod(clazz, methodNode.name, methodNode.desc, false)).findAny();
                if (result.isPresent()) {
                    methodNode2 = result.get();
                    if (methodNode2.instructions == null || methodNode2.instructions.size() == 0) {
                        logger.debug("Ignore method with empty instruction list");
                        continue;
                    }
                    if (exclusionManager.filterMethod(classNode.name.replaceAll("/", "."), methodNode2.name, methodNode2.desc)) continue;
                    logger.debug("Instrumented method {}{}", (Object)methodNode2.name, (Object)methodNode2.desc);
                    methodSensor.transformMethod(methodNode2, (methodNode2.access & 8) == 0 ? 1 : 0);
                    modified = true;
                    continue;
                }
                methodNode2 = methodSensor.transformForMissingMethod(classNode, clazz, this.warningsAsErrors);
                if (methodNode2 == null || exclusionManager.filterMethod(classNode.name.replaceAll("/", "."), methodNode2.name, methodNode2.desc)) continue;
                logger.debug("Add method {}{}", (Object)methodNode2.name, (Object)methodNode2.desc);
                classNode.methods.add(methodNode2);
                modified = true;
            }
        }
        return modified;
    }
}

