/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncrementalStateUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"IncrementalStateUtil");

    private IncrementalStateUtil() {
    }

    /*
     * Loose catch block
     */
    public static <T> T readIncrementalState(Path serializationFile) throws IOException {
        if (!Files.exists(serializationFile, new LinkOption[0])) {
            throw new FileNotFoundException("Unable to find incremental state storage " + serializationFile.toString());
        }
        try (InputStream fis = Files.newInputStream(serializationFile, new OpenOption[0]);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(fis);){
                object = ois.readObject();
            }
            return (T)object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public static <T> void storeIncrementalState(Path serializationFile, T incrementalState) throws IOException {
        logger.debug("Store incremental state into file " + serializationFile.toString());
        Files.deleteIfExists(serializationFile);
        Files.createDirectories(serializationFile.toAbsolutePath().getParent(), new FileAttribute[0]);
        Files.createFile(serializationFile, new FileAttribute[0]);
        try (OutputStream fos = Files.newOutputStream(serializationFile, new OpenOption[0]);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(incrementalState);
            oos.flush();
        }
    }
}

