/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.transformation;

import com.android.build.api.transform.TransformInvocation;
import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavor;
import com.dynatrace.tools.android.BaseTransformer;
import com.dynatrace.tools.android.BuildArtifactTransformer;
import com.dynatrace.tools.android.api.Configuration;
import com.dynatrace.tools.android.classpath.ClassPathGenerator;
import com.dynatrace.tools.android.transformation.AgpBuildArtifactTransformer;
import com.dynatrace.tools.android.transformation.BuildHandler;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.function.Supplier;

public class AgpTransformer
extends BaseTransformer<TransformInvocation> {
    private final Configuration configuration;
    private final List<File> bootClasspath;
    private final boolean isSessionReplayEnabled;
    private final InstrumentationFlavor instrumentationflavor;

    public AgpTransformer(Configuration configuration, List<File> bootClasspath, boolean isSessionReplayEnabled, InstrumentationFlavor instrumentationflavor) {
        this.configuration = configuration;
        this.bootClasspath = bootClasspath;
        this.isSessionReplayEnabled = isSessionReplayEnabled;
        this.instrumentationflavor = instrumentationflavor;
    }

    @Override
    protected Configuration determineConfiguration(TransformInvocation transformInvocation) {
        return this.configuration;
    }

    @Override
    protected void deleteOutputFiles(TransformInvocation transformInvocation) throws IOException {
        transformInvocation.getOutputProvider().deleteAll();
    }

    @Override
    protected Supplier<URL[]> getClassPathGenerator(TransformInvocation transformInvocation) {
        return new ClassPathGenerator(this.bootClasspath, transformInvocation.getInputs(), transformInvocation.getReferencedInputs());
    }

    @Override
    protected BuildArtifactTransformer<TransformInvocation> generateBuildArtifactTransformer(BuildHandler buildHandler, boolean isIncremental) {
        return new AgpBuildArtifactTransformer(buildHandler, isIncremental);
    }

    @Override
    protected InstrumentationFlavor getInstrumentationFlavor(TransformInvocation transformInvocation) {
        return this.instrumentationflavor;
    }

    @Override
    protected boolean isSessionReplayEnabled(TransformInvocation transformData) {
        return this.isSessionReplayEnabled;
    }
}

