/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalStateTracker
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger((String)"IncrementalStateTracker");
    private Map<String, List<String>> incrementalState = new HashMap<String, List<String>>();

    public boolean removeClass(String className) {
        List<String> oldValues = this.incrementalState.remove(className);
        if (oldValues == null) {
            return false;
        }
        logger.debug("Remove incremental state for class " + className);
        return true;
    }

    public boolean trackNewClass(String className, List<String> sensorKeys) {
        logger.debug("Add incremental state for class " + className);
        this.incrementalState.put(className, sensorKeys);
        return true;
    }

    public boolean verify(String className, List<String> sensorKeys) {
        return this.verify(className, sensorKeys, false);
    }

    public boolean verifyJarChanged(String className, List<String> sensorKeys) {
        return this.verify(className, sensorKeys, true);
    }

    public boolean verify(String className, List<String> sensorKeys, boolean acceptNewClasses) {
        boolean unmodified;
        List<String> prevTransformers = this.incrementalState.get(className);
        boolean bl = unmodified = prevTransformers == null ? acceptNewClasses : sensorKeys.equals(prevTransformers);
        if (!unmodified && logger.isDebugEnabled()) {
            logger.debug("cancel incremental transformation because of class {}", (Object)className);
            StringBuilder sb = new StringBuilder();
            sb.append("prev state: ");
            if (prevTransformers != null) {
                prevTransformers.forEach(sb::append);
            }
            sb.append("\n");
            sb.append("cur state: ");
            sensorKeys.forEach(sb::append);
            logger.debug(sb.toString());
        }
        return unmodified;
    }

    public Map<String, List<String>> getIncrementalState() {
        return this.incrementalState;
    }
}

