/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.transform.Transform;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.ApplicationVariant;
import com.android.build.api.variant.Variant;
import com.android.build.gradle.AppExtension;
import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavor;
import com.dynatrace.tools.android.AgpVersion;
import com.dynatrace.tools.android.AgpVersionConverter;
import com.dynatrace.tools.android.DynatracePlugin;
import com.dynatrace.tools.android.DynatraceTransformer;
import com.dynatrace.tools.android.InstrumentationFlavorParser;
import com.dynatrace.tools.android.PrintVariantAffiliationTask;
import com.dynatrace.tools.android.Version;
import com.dynatrace.tools.android.api.VerificationUtil;
import com.dynatrace.tools.android.dsl.DynatraceExtension;
import com.dynatrace.tools.android.dsl.VariantConfiguration;
import com.dynatrace.tools.android.dsl.VariantConfigurationUtil;
import com.dynatrace.tools.android.manifest.ManifestTransformationTask;
import com.dynatrace.tools.android.util.Utils;
import com.google.common.base.CaseFormat;
import java.io.File;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.TaskProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationPlugin
implements Plugin<Project> {
    private static final Logger logger = LoggerFactory.getLogger((String)"InstrumentationPlugin");
    private static final String INSTRUMENTATION_FLAVOR = "dynatrace.instrumentationFlavor";

    static DynatraceExtension determineExtension(Project project) {
        DynatraceExtension extension = (DynatraceExtension)project.getRootProject().getExtensions().findByType(DynatraceExtension.class);
        if (extension == null) {
            extension = (DynatraceExtension)project.getExtensions().findByType(DynatraceExtension.class);
        }
        return extension;
    }

    public void apply(Project project) {
        DynatraceExtension dynatraceExtension = InstrumentationPlugin.determineExtension(project);
        if (dynatraceExtension == null) {
            throw new GradleException("No Dynatrace extension found");
        }
        AgpVersion agpVersion = new AgpVersionConverter().determineAndroidPluginVersion(project);
        AndroidComponentsExtension androidExtension = (AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class);
        boolean isApplicationModule = project.getPlugins().hasPlugin("com.android.application");
        if (isApplicationModule) {
            this.configureDependencies(project, dynatraceExtension);
        }
        TaskProvider<PrintVariantAffiliationTask> pvTask = this.createPrintVariantAffiliationTask(project);
        androidExtension.onVariants(androidExtension.selector().all(), variant -> {
            Optional<VariantConfiguration> configuration = this.getVerifiedConfiguration((Variant)variant, dynatraceExtension);
            pvTask.configure(task -> task.getVariantMapping().put((Object)variant.getName(), configuration.map(VariantConfiguration::getName)));
            configuration.ifPresent(config -> {
                if (config.isEnabled()) {
                    this.setupBytecodeInstrumentation((Variant)variant, project, dynatraceExtension, (VariantConfiguration)config, agpVersion);
                    if (variant instanceof ApplicationVariant) {
                        this.setupManifestInstrumentation((ApplicationVariant)variant, project, dynatraceExtension);
                    }
                }
            });
        });
        AppExtension appExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
        DynatraceTransformer transformer = this.createDynatraceTransformer(project, dynatraceExtension, appExtension);
        appExtension.registerTransform((Transform)transformer, new Object[0]);
        String genericTaskName = this.generateTransformTaskNamePrefix(transformer);
        project.afterEvaluate(pluginParams -> appExtension.getApplicationVariants().configureEach(applicationVariant -> {
            Optional<VariantConfiguration> result = !dynatraceExtension.isPluginEnabled() ? Optional.empty() : VariantConfigurationUtil.determineVariantConfiguration(dynatraceExtension, applicationVariant.getName());
            this.setupBytecodeInstrumentationLegacy(project, appExtension, transformer, genericTaskName, (com.android.build.gradle.api.ApplicationVariant)applicationVariant, result);
        }));
    }

    private TaskProvider<PrintVariantAffiliationTask> createPrintVariantAffiliationTask(Project project) {
        return project.getTasks().register("printVariantAffiliation", PrintVariantAffiliationTask.class, printVariantAffiliationTask -> {
            printVariantAffiliationTask.setGroup("transformation");
            printVariantAffiliationTask.setDescription("Prints which Dynatrace variant configuration is used for each variant");
        });
    }

    private Optional<VariantConfiguration> getVerifiedConfiguration(Variant variant, DynatraceExtension dynatraceExtension) {
        if (dynatraceExtension.isStrictMode() && dynatraceExtension.getConfigurations().isEmpty()) {
            throw new GradleException("No configuration for the Dynatrace Android Gradle plugin found! Please copy the configuration block from the instrumentation wizard to the proper location.");
        }
        if (!dynatraceExtension.isPluginEnabled()) {
            return Optional.empty();
        }
        Optional<VariantConfiguration> result = VariantConfigurationUtil.determineVariantConfiguration(dynatraceExtension, variant.getName());
        if (result.isPresent()) {
            VariantConfiguration config = result.get();
            VerificationUtil.verifyVariantConfiguration("Invalid configuration '" + config.getName() + "': ", config);
            return result;
        }
        if (dynatraceExtension.isStrictMode()) {
            throw new GradleException("No configuration for the Dynatrace Android Gradle plugin found that matches variant: '" + variant.getName() + "'");
        }
        return Optional.empty();
    }

    private void setupBytecodeInstrumentation(Variant variant, Project project, DynatraceExtension dynatraceExtension, VariantConfiguration configuration, AgpVersion agpVersion) {
        logger.debug("Variant " + variant.getName() + " will be instrumented");
    }

    private void setupManifestInstrumentation(ApplicationVariant variant, Project project, DynatraceExtension dynatraceExtension) {
        TaskProvider manifestTransformTask = project.getTasks().register("instrument" + Utils.capitalize(variant.getName()) + "ManifestWithDynatrace", ManifestTransformationTask.class);
        variant.getArtifacts().use(manifestTransformTask).wiredWithFiles(ManifestTransformationTask::getInputManifest, ManifestTransformationTask::getInstrumentedManifest).toTransform((Artifact.Single)SingleArtifact.MERGED_MANIFEST.INSTANCE);
    }

    private void configureDependencies(Project project, DynatraceExtension extension) {
        Configuration config = project.getConfigurations().getByName("api");
        config.withDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)DynatracePlugin.agentDependency())));
        if (extension.getConfigurations().stream().anyMatch(it -> it.getSessionReplay().isEnabled())) {
            config.withDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)("com.dynatrace.agent:android-replay-agent:" + Version.getVersion()))));
        }
    }

    private DynatraceTransformer createDynatraceTransformer(Project project, DynatraceExtension dynatraceExtension, AppExtension appExtension) {
        InstrumentationFlavor instrFlavor;
        try {
            instrFlavor = new InstrumentationFlavorParser().parse((String)project.getRootProject().findProperty(INSTRUMENTATION_FLAVOR));
        }
        catch (IllegalArgumentException e) {
            throw new GradleException("Can't parse value from property 'dynatrace.instrumentationFlavor'", (Throwable)e);
        }
        return new DynatraceTransformer(dynatraceExtension, appExtension, instrFlavor);
    }

    private void setupBytecodeInstrumentationLegacy(Project project, AppExtension appExtension, DynatraceTransformer transformer, String genericTaskName, com.android.build.gradle.api.ApplicationVariant applicationVariant, Optional<VariantConfiguration> result) {
        TaskProvider transformTaskProvider = project.getTasks().named(genericTaskName + Utils.capitalize(applicationVariant.getName()));
        transformTaskProvider.configure(this.configureTransformTask(appExtension, applicationVariant, transformer, result));
    }

    private Action<? super Task> configureTransformTask(AppExtension androidExt, com.android.build.gradle.api.ApplicationVariant applicationVariant, DynatraceTransformer transformer, Optional<VariantConfiguration> result) {
        return task -> {
            TaskInputs input = task.getInputs();
            TaskOutputs output = task.getOutputs();
            boolean caching = false;
            if (result.isPresent()) {
                VariantConfiguration origConf = (VariantConfiguration)result.get();
                transformer.addVariantSpecificConfiguration(applicationVariant.getName(), origConf);
                input.property("variantConfiguration", (Object)VariantConfigurationUtil.copy(origConf));
                caching = origConf.isEnabled();
            }
            input.files(new Object[]{androidExt.getBootClasspath()}).withPropertyName("bootClasspath").withPathSensitivity(PathSensitivity.NAME_ONLY);
            output.file((Object)new File(task.getTemporaryDir(), "transform.ser")).withPropertyName("incrementalState");
            if (!caching) {
                output.cacheIf(task1 -> false);
            }
        };
    }

    private String generateTransformTaskNamePrefix(Transform transformer) {
        return "transform" + transformer.getInputTypes().stream().map(inputType -> CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, inputType.name())).sorted().collect(Collectors.joining("And")) + "With" + Utils.capitalize(transformer.getName()) + "For";
    }
}

