/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.AppExtension;
import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavor;
import com.dynatrace.tools.android.api.Configuration;
import com.dynatrace.tools.android.dsl.DynatraceExtension;
import com.dynatrace.tools.android.dsl.VariantConfiguration;
import com.dynatrace.tools.android.transformation.AgpTransformer;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynatraceTransformer
extends Transform {
    private static final Logger logger = LoggerFactory.getLogger((String)"DynatraceTransformer");
    private final DynatraceExtension extension;
    private final AppExtension appExtension;
    private final Map<String, VariantConfiguration> variantSpecificConfiguration;
    private final InstrumentationFlavor instrumentationflavor;

    DynatraceTransformer(DynatraceExtension extension, AppExtension appExtension, InstrumentationFlavor instrumentationflavor) {
        this.extension = extension;
        this.appExtension = appExtension;
        this.variantSpecificConfiguration = new HashMap<String, VariantConfiguration>();
        this.instrumentationflavor = instrumentationflavor;
    }

    public String getName() {
        return "dynatraceTransformer";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT, (Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES, (Object)QualifiedContent.Scope.SUB_PROJECTS);
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return ImmutableSet.of((Object)QualifiedContent.Scope.PROVIDED_ONLY);
    }

    public boolean isIncremental() {
        return true;
    }

    public Map<String, Object> getParameterInputs() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isPluginEnabled", this.extension.isPluginEnabled());
        map.put("isStrictMode", this.extension.isStrictMode());
        return map;
    }

    public boolean isCacheable() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws IOException {
        File tempDir = transformInvocation.getContext().getTemporaryDir();
        AgpTransformer transformer = new AgpTransformer(this.determineConfiguration(transformInvocation), this.appExtension.getBootClasspath(), this.instrumentationflavor);
        transformer.transform(transformInvocation, tempDir.toPath(), transformInvocation.isIncremental());
    }

    public void addVariantSpecificConfiguration(String name, VariantConfiguration variantConfiguration) {
        this.variantSpecificConfiguration.put(name, variantConfiguration);
    }

    Configuration determineConfiguration(TransformInvocation transformInvocation) {
        if (!this.extension.isPluginEnabled()) {
            logger.debug("Dynatrace Android Gradle plugin is disabled");
            return null;
        }
        String variantName = transformInvocation.getContext().getVariantName();
        VariantConfiguration configuration = this.variantSpecificConfiguration.get(variantName);
        if (configuration != null) {
            logger.debug("Variant '{}' will use configuration '{}'", (Object)variantName, (Object)configuration.getName());
            return configuration;
        }
        if (variantName.endsWith("AndroidTest")) {
            logger.debug("Deactivate transformation for androidTest artifacts");
        } else {
            if (this.extension.isStrictMode()) {
                throw new IllegalArgumentException("Variant '" + variantName + "' has no matching configuration");
            }
            logger.debug("Variant '{}' has no matching configuration", (Object)variantName);
        }
        return null;
    }
}

