/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.util;

import com.dynatrace.android.instrumentation.UnknownLambdaTagException;
import com.dynatrace.android.instrumentation.util.LambdaConverterData;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger((String)"Utils");

    public static LambdaConverterData extractLambdaIntoExtraMethod(String methodName, Handle methodHandle, org.objectweb.asm.Type typeMethodDesc, org.objectweb.asm.Type[] callArgumentTypes) throws UnknownLambdaTagException {
        int opcode;
        ArrayList<org.objectweb.asm.Type> types = new ArrayList<org.objectweb.asm.Type>();
        types.addAll(Arrays.asList(callArgumentTypes));
        types.addAll(Arrays.asList(typeMethodDesc.getArgumentTypes()));
        StringBuilder sb = new StringBuilder("(");
        for (org.objectweb.asm.Type paramType : types) {
            sb.append(paramType.getDescriptor());
        }
        sb.append(")");
        sb.append(typeMethodDesc.getReturnType().getDescriptor());
        int access = 4106;
        MethodNode methodNode = new MethodNode(access, methodName, sb.toString(), null, null);
        InsnList instructions = methodNode.instructions;
        if (methodHandle.getTag() == 8) {
            instructions.add((AbstractInsnNode)new TypeInsnNode(187, methodHandle.getOwner()));
            instructions.add((AbstractInsnNode)new InsnNode(89));
        }
        int slotCount = 0;
        for (org.objectweb.asm.Type paramType : types) {
            instructions.add((AbstractInsnNode)new VarInsnNode(paramType.getOpcode(21), slotCount));
            slotCount += paramType.getSize();
        }
        switch (methodHandle.getTag()) {
            case 5: {
                opcode = 182;
                break;
            }
            case 6: {
                opcode = 184;
                break;
            }
            case 7: {
                opcode = 183;
                break;
            }
            case 8: {
                opcode = 183;
                break;
            }
            case 9: {
                opcode = 185;
                break;
            }
            default: {
                throw new UnknownLambdaTagException("Unsupported tag value " + methodHandle.getTag() + " in method handle");
            }
        }
        MethodInsnNode methodInsnNode = new MethodInsnNode(opcode, methodHandle.getOwner(), methodHandle.getName(), methodHandle.getDesc(), methodHandle.isInterface());
        instructions.add((AbstractInsnNode)methodInsnNode);
        instructions.add((AbstractInsnNode)new InsnNode(typeMethodDesc.getReturnType().getOpcode(172)));
        return new LambdaConverterData(methodNode, methodInsnNode);
    }

    public static MethodNode generateSyntheticMethod(String oldClassName, Method method, String newMethodName, boolean isSuperCall) {
        boolean isPrivate;
        boolean isStatic;
        String signature;
        org.objectweb.asm.Type methodDesc = org.objectweb.asm.Type.getType((Method)method);
        Class<?>[] exceptionClasses = method.getExceptionTypes();
        String[] exceptionNames = new String[exceptionClasses.length];
        for (int ii = 0; ii < exceptionClasses.length; ++ii) {
            exceptionNames[ii] = org.objectweb.asm.Type.getInternalName(exceptionClasses[ii]);
        }
        int modifiers = method.getModifiers() & 0xFFFFFADF | 0x1000;
        String desc = methodDesc.getDescriptor();
        try {
            int endIndex;
            signature = Utils.generateSignature(method);
            int n = endIndex = exceptionNames.length <= 0 ? signature.length() : signature.indexOf("^");
            if (desc.equals(signature.substring(0, endIndex))) {
                signature = null;
            }
        }
        catch (RuntimeException e) {
            signature = null;
            logger.info("discard signature value for synthetic method", (Throwable)e);
        }
        MethodNode methodNode = new MethodNode(modifiers, newMethodName, desc, signature, exceptionNames);
        InsnList instructions = methodNode.instructions;
        int slotCount = 0;
        boolean bl = isStatic = (method.getModifiers() & 8) != 0;
        if (!isStatic) {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, slotCount));
            ++slotCount;
        }
        for (org.objectweb.asm.Type paramType : methodDesc.getArgumentTypes()) {
            instructions.add((AbstractInsnNode)new VarInsnNode(paramType.getOpcode(21), slotCount));
            slotCount += paramType.getSize();
        }
        boolean bl2 = isPrivate = isSuperCall || (method.getModifiers() & 2) != 0;
        instructions.add((AbstractInsnNode)new MethodInsnNode(isStatic ? 184 : (isPrivate ? 183 : 182), oldClassName, method.getName(), methodDesc.getDescriptor(), false));
        instructions.add((AbstractInsnNode)new InsnNode(methodDesc.getReturnType().getOpcode(172)));
        return methodNode;
    }

    private static String generateSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        TypeVariable<Method>[] typeParams = method.getTypeParameters();
        if (typeParams.length > 0) {
            sb.append("<");
            for (Type type : typeParams) {
                sb.append(type.getName());
                boolean first = true;
                for (Type type2 : type.getBounds()) {
                    sb.append(":");
                    sb.append(Utils.determineType(type2, first));
                    first = false;
                }
            }
            sb.append(">");
        }
        sb.append("(");
        for (Type type : method.getGenericParameterTypes()) {
            sb.append(Utils.determineType(type, false));
        }
        sb.append(")");
        sb.append(Utils.determineType(method.getGenericReturnType(), false));
        for (Type type : method.getGenericExceptionTypes()) {
            sb.append("^");
            sb.append(Utils.determineType(type, false));
        }
        return sb.toString();
    }

    private static String determineType(Type type, boolean isFormalTypeParameters) {
        if (type instanceof TypeVariable) {
            return "T" + type + ";";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class clazz = (Class)parameterizedType.getRawType();
            StringBuilder sb = new StringBuilder();
            if (isFormalTypeParameters && clazz.isInterface()) {
                sb.append(":");
            }
            sb.append(org.objectweb.asm.Type.getType((Class)clazz).getDescriptor());
            sb.deleteCharAt(sb.length() - 1);
            sb.append("<");
            for (Type subTypes : parameterizedType.getActualTypeArguments()) {
                sb.append(Utils.determineType(subTypes, false));
            }
            sb.append(">;");
            return sb.toString();
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            String desc = org.objectweb.asm.Type.getType((Class)clazz).getDescriptor();
            if (isFormalTypeParameters && clazz.isInterface()) {
                return ":" + desc;
            }
            return desc;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] typesLower = wildcardType.getLowerBounds();
            if (typesLower.length > 0) {
                return "-" + Utils.determineType(typesLower[0], false);
            }
            Type[] typesUpper = wildcardType.getUpperBounds();
            if (typesUpper.length > 0 && typesUpper[0] != Object.class) {
                return "+" + Utils.determineType(typesUpper[0], false);
            }
            return "*";
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return "[" + Utils.determineType(genericArrayType.getGenericComponentType(), false);
        }
        throw new UnsupportedOperationException("unknown type class " + type.getClass().getName());
    }

    public static MethodInsnNode generateMethodCall(Method method) {
        int opcode;
        boolean isInterfaceCall;
        if ((method.getModifiers() & 8) != 0) {
            isInterfaceCall = false;
            opcode = 184;
        } else if (method.getDeclaringClass().isInterface()) {
            opcode = 185;
            isInterfaceCall = true;
        } else {
            isInterfaceCall = false;
            opcode = (method.getModifiers() & 2) != 0 ? 183 : 182;
        }
        return new MethodInsnNode(opcode, org.objectweb.asm.Type.getType(method.getDeclaringClass()).getInternalName(), method.getName(), org.objectweb.asm.Type.getType((Method)method).getDescriptor(), isInterfaceCall);
    }

    public static MethodInsnNode generateConstructorCall(Constructor ctor) {
        return new MethodInsnNode(183, org.objectweb.asm.Type.getType(ctor.getDeclaringClass()).getInternalName(), "<init>", org.objectweb.asm.Type.getType((Constructor)ctor).getDescriptor(), false);
    }

    public static void pushValueToStack(InsnList insn, int value) {
        insn.add((AbstractInsnNode)new LdcInsnNode((Object)value));
    }

    public static void pushValueToStack(InsnList insn, boolean value) {
        insn.add((AbstractInsnNode)new InsnNode(value ? 4 : 3));
    }

    public static void pushValueToStack(InsnList insn, String value) {
        if (value == null) {
            Utils.pushNullToStack(insn);
            return;
        }
        insn.add((AbstractInsnNode)new LdcInsnNode((Object)value));
    }

    public static void pushValueToStack(InsnList insn, String[] values) {
        if (values == null) {
            Utils.pushNullToStack(insn);
            return;
        }
        Utils.pushValueToStack(insn, values.length);
        org.objectweb.asm.Type t = org.objectweb.asm.Type.getType(values.getClass());
        insn.add((AbstractInsnNode)new TypeInsnNode(189, t.getElementType().getInternalName()));
        for (int i = 0; i < values.length; ++i) {
            insn.add((AbstractInsnNode)new InsnNode(89));
            Utils.pushValueToStack(insn, i);
            Utils.pushValueToStack(insn, values[i]);
            insn.add((AbstractInsnNode)new InsnNode(83));
        }
    }

    public static void pushNullToStack(InsnList insn) {
        insn.add((AbstractInsnNode)new InsnNode(1));
    }

    public static <E extends Enum<E>> void pushEnumToStack(InsnList insn, E enumValue) {
        if (enumValue == null) {
            Utils.pushNullToStack(insn);
            return;
        }
        org.objectweb.asm.Type type = org.objectweb.asm.Type.getType(enumValue.getClass());
        insn.add((AbstractInsnNode)new FieldInsnNode(178, type.getInternalName(), enumValue.name(), type.getDescriptor()));
    }

    public static void replaceGetterInstructions(InsnList insn, int valueToReturn) {
        insn.clear();
        Utils.pushValueToStack(insn, valueToReturn);
        insn.add((AbstractInsnNode)new InsnNode(172));
    }

    public static <E extends Enum<E>> void replaceGetterInstructions(InsnList insn, Enum<?> enumValue) {
        insn.clear();
        org.objectweb.asm.Type type = org.objectweb.asm.Type.getType(enumValue.getDeclaringClass());
        insn.add((AbstractInsnNode)new FieldInsnNode(178, type.getInternalName(), enumValue.name(), type.getDescriptor()));
        insn.add((AbstractInsnNode)new InsnNode(176));
    }

    public static <E extends Enum<E>> Enum<? extends Enum<?>> translateEnum(Class<?> targetEnumClass, E enumValue, Function<E, String> translation) {
        if (enumValue == null) {
            throw new IllegalArgumentException("The given enum value must not be null");
        }
        if (!targetEnumClass.isEnum()) {
            throw new IllegalArgumentException("Class " + targetEnumClass.getName() + " is not an Enum");
        }
        Class<?> castedTargetEnumClass = targetEnumClass;
        String enumName = translation.apply(enumValue);
        if (enumName == null) {
            throw new IllegalArgumentException("The given translation function did not return a value for " + enumValue.name());
        }
        Optional<Enum> valueCounterpart = Arrays.stream((Enum[])castedTargetEnumClass.getEnumConstants()).filter(enumConstant -> enumConstant.name().equals(enumName)).findAny();
        if (!valueCounterpart.isPresent()) {
            throw new UnsupportedOperationException("Cannot translate enum " + enumValue.getDeclaringClass().getName() + "#" + enumValue.name() + " to " + targetEnumClass.getName() + "#" + enumName);
        }
        return valueCounterpart.get();
    }

    public static void replaceGetterInstructions(InsnList insn, boolean valueToReturn) {
        insn.clear();
        Utils.pushValueToStack(insn, valueToReturn);
        insn.add((AbstractInsnNode)new InsnNode(172));
    }

    public static void replaceGetterInstructions(InsnList insn, String[] valuesToReturn) {
        insn.clear();
        Utils.pushValueToStack(insn, valuesToReturn);
        insn.add((AbstractInsnNode)new InsnNode(176));
    }
}

