/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.dynatrace.android.instrumentation.Instrumentor;
import com.dynatrace.android.instrumentation.InvalidIncrementalStateException;
import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavor;
import com.dynatrace.tools.android.BuildArtifactTransformer;
import com.dynatrace.tools.android.IncrementalStateTrackerGroup;
import com.dynatrace.tools.android.InstrumentationException;
import com.dynatrace.tools.android.InstrumentorConfigurator;
import com.dynatrace.tools.android.api.Configuration;
import com.dynatrace.tools.android.api.ExcludeOptions;
import com.dynatrace.tools.android.classpath.ClassPathAnalyzer;
import com.dynatrace.tools.android.transformation.BuildHandler;
import com.dynatrace.tools.android.transformation.InstrumentedBuild;
import com.dynatrace.tools.android.transformation.NonInstrumentedBuild;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTransformer<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)"BaseTransformer");
    private Path serializationFile;
    private Path dumpFile;

    protected abstract Configuration determineConfiguration(T var1);

    public void transform(T transformData, Path tempDir, boolean isIncremental) throws InstrumentationException, IOException {
        if (tempDir == null) {
            throw new IllegalArgumentException("No temporary directory defined");
        }
        Configuration configuration = this.determineConfiguration(transformData);
        if (configuration != null) {
            logger.debug("{}", (Object)configuration);
            if (!configuration.isEnabled()) {
                logger.debug("Instrumentation is disabled");
                configuration = null;
            }
        }
        Files.createDirectories(tempDir, new FileAttribute[0]);
        this.serializationFile = tempDir.resolve("transform.ser");
        this.dumpFile = tempDir.resolve("error.class.dump");
        Files.deleteIfExists(this.dumpFile);
        String txtIncremental = isIncremental ? "incremental" : "non-incremental";
        logger.debug("Start " + txtIncremental + " transformation");
        try {
            this.transform(transformData, isIncremental, configuration);
        }
        catch (InvalidIncrementalStateException e) {
            if (!isIncremental) {
                throw new InstrumentationException("Unexpected error obtained. Please open a support ticket", e);
            }
            logger.debug("Switch from incremental to non-incremental transformation");
            try {
                this.transform(transformData, false, configuration);
            }
            catch (InvalidIncrementalStateException e1) {
                throw new InstrumentationException("Unexpected error obtained. Please open a support ticket", e);
            }
        }
    }

    protected abstract void deleteOutputFiles(T var1) throws IOException;

    protected abstract Supplier<URL[]> getClassPathGenerator(T var1);

    protected abstract BuildArtifactTransformer<T> generateBuildArtifactTransformer(BuildHandler var1, boolean var2);

    protected abstract InstrumentationFlavor getInstrumentationFlavor(T var1);

    protected void transform(T transformData, boolean isIncremental, Configuration configuration) throws InstrumentationException, IOException, InvalidIncrementalStateException {
        if (!isIncremental) {
            logger.debug("Delete all files for non-incremental build");
            this.deleteOutputFiles(transformData);
        }
        if (configuration == null) {
            Files.deleteIfExists(this.serializationFile);
            this.generateBuildArtifactTransformer(new NonInstrumentedBuild(), isIncremental).handleTransformation(transformData);
        } else {
            IncrementalStateTrackerGroup tracker = IncrementalStateTrackerGroup.create(this.serializationFile, isIncremental);
            Supplier<URL[]> classPathGenerator = this.getClassPathGenerator(transformData);
            try (URLClassLoader classLoader = URLClassLoader.newInstance(classPathGenerator.get(), null);){
                Instrumentor instrumentor;
                logger.debug("classLoader content " + Arrays.toString(classLoader.getURLs()));
                new ClassPathAnalyzer(classLoader).verifyClassPath(configuration.getSessionReplay().isEnabled());
                ExcludeOptions excludeOptions = configuration.getExclude();
                ExclusionManager exclusionManager = new ExclusionManager(excludeOptions.getClassLevelFilter(), excludeOptions.getMethodLevelFilter());
                try {
                    instrumentor = new InstrumentorConfigurator(configuration, exclusionManager, this.getInstrumentationFlavor(transformData)).generateVariantSpecificInstrumentor(classLoader, this::dumpClass);
                }
                catch (Exception e) {
                    throw new InstrumentationException("Unable to instantiate instrumentor, Please open a support ticket", e);
                }
                this.generateBuildArtifactTransformer(new InstrumentedBuild(instrumentor, tracker), isIncremental).handleTransformation(transformData);
                tracker.store();
                Set<String> exclusionReport = exclusionManager.getExclusionReport();
                if (!exclusionReport.isEmpty()) {
                    logger.debug("The following classes/methods have been excluded from instrumentation:");
                    exclusionReport.stream().sorted(String::compareTo).forEach(s -> logger.debug("  " + s));
                }
            }
        }
    }

    private void dumpClass(byte[] bytes) {
        try (OutputStream out = Files.newOutputStream(this.dumpFile, new OpenOption[0]);){
            out.write(bytes);
            out.flush();
        }
        catch (IOException ioe) {
            logger.info("unable to dump class file", (Throwable)ioe);
        }
    }
}

