/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform;

import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.instrumentor.InstructionInstrumentor;
import com.dynatrace.android.instrumentation.transform.instrumentor.LambdaInstrumentor;
import com.dynatrace.android.instrumentation.transform.instrumentor.MethodInstrumentor;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class DefaultSubTransformer
implements SubTransformer {
    private List<SensorGroup<InstructionSensor>> instructionSensors;
    private List<SensorGroup<MethodSensor>> methodSensors;
    private String name;
    private InstructionInstrumentor instructionInstrumentor;
    private MethodInstrumentor methodInstrumentor;
    private LambdaInstrumentor lambdaInstrumentor;

    public DefaultSubTransformer(String name, List<SensorGroup<InstructionSensor>> instructionSensors, List<SensorGroup<MethodSensor>> methodSensors, ClassLoader classLoader, boolean warningsAsErrors) {
        this.name = name;
        this.instructionSensors = instructionSensors;
        this.methodSensors = methodSensors;
        this.instructionInstrumentor = new InstructionInstrumentor(classLoader, instructionSensors, warningsAsErrors);
        this.methodInstrumentor = new MethodInstrumentor(methodSensors);
        this.lambdaInstrumentor = new LambdaInstrumentor(classLoader, instructionSensors, methodSensors, warningsAsErrors);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean transformClass(Class<?> clazz, ClassNode classNode, ExclusionManager exclusionManager) {
        return false;
    }

    @Override
    public boolean transformMethod(Class<?> clazz, ClassNode classNode, MethodNode methodNode, ExclusionManager exclusionManager) {
        boolean modified = false;
        modified |= this.instructionInstrumentor.transformMethod(methodNode, exclusionManager);
        modified |= this.methodInstrumentor.transformMethod(clazz, methodNode);
        return modified |= this.lambdaInstrumentor.transformMethod(classNode, methodNode, exclusionManager);
    }

    @Override
    public boolean shouldBeInstrumented(Class<?> clazz) {
        return this.instructionSensors.stream().noneMatch(sensor -> sensor.matchClass(clazz));
    }
}

