/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertAfterInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertBeforeInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.VarInsnNode;

public class HybridAppTransformerFactory
implements TransformerFactory {
    private static final String COOKIE_MANAGER = "android.webkit.CookieManager";
    private static final String VALUE_CALLBACK = "android.webkit.ValueCallback";
    private static final String WEB_VIEW = "android.webkit.WebView";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
        instructionSensors.add(this.generateCookieManagerSensors(classLoader));
        instructionSensors.add(this.generateWebViewSensors(classLoader));
        return new DefaultSubTransformer("HybridAppTransformer", instructionSensors, new ArrayList<SensorGroup<MethodSensor>>(), classLoader, warningsAsErrors);
    }

    private SensorGroup<InstructionSensor> generateCookieManagerSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> valueCallback = Class.forName(VALUE_CALLBACK, false, classLoader);
        Class<?> cookieManager = Class.forName(COOKIE_MANAGER, false, classLoader);
        Method removeAllCookie = cookieManager.getDeclaredMethod("removeAllCookie", new Class[0]);
        Method removeAllCookies = cookieManager.getDeclaredMethod("removeAllCookies", valueCallback);
        Method removeSessionCookie = cookieManager.getDeclaredMethod("removeSessionCookie", new Class[0]);
        Method removeSessionCookies = cookieManager.getDeclaredMethod("removeSessionCookies", valueCallback);
        Class<?> dynatraceClass = Class.forName("com.dynatrace.android.agent.Dynatrace", false, classLoader);
        Method restoreCookies = dynatraceClass.getDeclaredMethod("restoreCookies", new Class[0]);
        TransformerUtils.InstructionFactory factory = instructions -> instructions.add((AbstractInsnNode)Utils.generateMethodCall(restoreCookies));
        return new SensorGroupImpl<InstructionSensor>(cookieManager, new InsertAfterInstructionSensor(removeAllCookie, factory), new InsertAfterInstructionSensor(removeAllCookies, factory), new InsertAfterInstructionSensor(removeSessionCookie, factory), new InsertAfterInstructionSensor(removeSessionCookies, factory));
    }

    private SensorGroup<InstructionSensor> generateWebViewSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> webView = Class.forName(WEB_VIEW, false, classLoader);
        Method loadUrlOnlyString = webView.getDeclaredMethod("loadUrl", String.class);
        Method loadUrlWithMap = webView.getDeclaredMethod("loadUrl", String.class, Map.class);
        Class<?> callback = Class.forName("com.dynatrace.android.agent.Dynatrace", false, classLoader);
        Method instrumentWebView = callback.getDeclaredMethod("instrumentWebView", webView);
        Function<Integer, InsnList> transformer = startIndex -> {
            InsnList instructions = new InsnList();
            instructions.add((AbstractInsnNode)new VarInsnNode(25, startIndex.intValue()));
            instructions.add((AbstractInsnNode)Utils.generateMethodCall(instrumentWebView));
            return instructions;
        };
        InsertBeforeInstructionSensor sensorLoadUrlOnlyString = new InsertBeforeInstructionSensor(loadUrlOnlyString, transformer);
        InsertBeforeInstructionSensor sensorLoadUrlWithMap = new InsertBeforeInstructionSensor(loadUrlWithMap, transformer);
        return new SensorGroupImpl<InstructionSensor>(webView, sensorLoadUrlOnlyString, sensorLoadUrlWithMap);
    }
}

