/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.filter.NonAbstractClassMatcher;
import com.dynatrace.android.instrumentation.sensor.method.MandatoryMethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MandatoryMethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.LifecycleSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LifecycleTransformerFactory
implements TransformerFactory {
    private static final String APPLICATION = "android.app.Application";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        ArrayList<SensorGroup<MandatoryMethodSensor>> methodSensors = new ArrayList<SensorGroup<MandatoryMethodSensor>>();
        methodSensors.add(this.generateApplicationSensors(classLoader));
        return new LifecycleSubTransformer("LifecycleTransformer", methodSensors, warningsAsErrors);
    }

    @Override
    public List<String> mandatoryClasses() {
        return Collections.singletonList("com.dynatrace.android.app.Application");
    }

    private SensorGroup<MandatoryMethodSensor> generateApplicationSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> application = Class.forName(APPLICATION, false, classLoader);
        Method onCreate = application.getDeclaredMethod("onCreate", new Class[0]);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.Callback", false, classLoader);
        Method instr_onCreate = callback.getDeclaredMethod("onCreate", application);
        return new SensorGroupImpl<MandatoryMethodSensor>(new NonAbstractClassMatcher(application), new MandatoryMethodSensorImpl(onCreate, new StartMethodTransformation(instr_onCreate, ParameterInstructionProvider.withThis())));
    }
}

